/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.core.tile.ccu;

import com.valkyrieofnight.envirocore.core.energy.UniPotentialBattery;
import com.valkyrieofnight.envirocore.core.tile.ccu.ColoredProcessorCCUTile;
import com.valkyrieofnight.envirocore.m_comp.m_io.tile.IIOTile;
import com.valkyrieofnight.envirocore.multiblock.io.IEnviroEnergyIO;
import com.valkyrieofnight.envirocore.multiblock.io.IForgeEnergyIO;
import com.valkyrieofnight.enviroenergyapi.api.Energy;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.SaveDataType;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.multiblock.ui.container.ControllerContainer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;

public abstract class PotEnergyCCUTile<CONT extends ControllerContainer<? extends PotEnergyCCUTile>>
extends ColoredProcessorCCUTile<CONT>
implements IForgeEnergyIO,
IEnviroEnergyIO {
    protected UniPotentialBattery battery;

    public PotEnergyCCUTile(TileEntityType<?> tileEntityTypeIn, UniPotentialBattery battery) {
        super(tileEntityTypeIn);
        this.battery = battery;
    }

    public CompoundNBT save(CompoundNBT nbt, SaveDataType type) {
        super.save(nbt, type);
        if (type == SaveDataType.TILE || type == SaveDataType.TO_CLIENT) {
            nbt.func_218657_a("battery", (INBT)this.battery.serializeNBT());
        }
        return nbt;
    }

    public void load(CompoundNBT nbt, SaveDataType type) {
        super.load(nbt, type);
        if ((type == SaveDataType.TILE || type == SaveDataType.FROM_SERVER) && nbt.func_74764_b("battery")) {
            this.battery.deserializeNBT(nbt.func_74775_l("battery"));
        }
    }

    @Override
    public int provideFE(@NotNull IIOTile slave, int provided, boolean simulate) {
        if (slave == null) {
            return 0;
        }
        return this.battery.receiveEnergy(provided, simulate);
    }

    @Override
    public int consumeFE(@NotNull IIOTile slave, int requested, boolean simulate) {
        if (slave == null) {
            return 0;
        }
        return this.battery.extractEnergy(requested, simulate);
    }

    @Override
    public Energy provideEE(@NotNull IIOTile slave, @NotNull Energy provided, boolean sim) {
        if (slave == null) {
            return Energy.ZERO;
        }
        return this.battery.receiveEnergy(provided, sim);
    }

    @Override
    public Energy consumeEE(@NotNull IIOTile slave, @NotNull Energy requested, boolean sim) {
        if (slave == null) {
            return Energy.ZERO;
        }
        return this.battery.extractEnergy(requested, sim);
    }

    public long getPotentialCapacity() {
        return this.battery.getPotentialCapacity();
    }

    public long getPotentialStored() {
        return this.battery.getPotentialStored();
    }

    public float getEnergyScaled() {
        return this.battery.getPotentialScaled();
    }
}

