/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.envirocore.core.block;

import com.valkyrieofnight.envirocore.EnviroCore;
import com.valkyrieofnight.envirocore.core.TierInfo;
import com.valkyrieofnight.envirocore.core.util.EnviroUtil;
import com.valkyrieofnight.vlib.core.obj.block.base.BlockProps;
import com.valkyrieofnight.vlib.core.obj.block.base.color.IColorableBlockWithTile;
import com.valkyrieofnight.vlib.core.obj.block.withtile.VLTileBlock;
import com.valkyrieofnight.vlib.core.obj.tileentity.VLTileEntity;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.color.IColorProviderTile;
import com.valkyrieofnight.vlib.core.util.annotations.Nullable;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;
import com.valkyrieofnight.vlib.core.util.tooltip.QuickTooltips;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.module.config.IConfig;
import com.valkyrieofnight.vlib.multiblock.StructureMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ECColoredCCUBlock
extends VLTileBlock
implements IColorableBlockWithTile {
    protected TierInfo tier;
    protected Provider<StructureMap> structureList;
    private Color4 baseColor = new Color4(255, 255, 255, 255);
    private Color4 coreColor = new Color4(255, 255, 255, 255);
    private Color4 tierColor;

    public ECColoredCCUBlock(VLID id, TierInfo info, Provider<StructureMap> structureList, BlockProps props, Class<? extends VLTileEntity> tile) {
        super(id, props.harvestTool(info.getHarvestTool()).harvestLevel(info.getHarvestLevel()).strength(info.getHardness(), info.getResistance()).tab((ItemGroup)EnviroCore.CCUS).notSolid().nameStyle(info.getNameStyle()), tile);
        this.tier = info;
        this.structureList = structureList;
        this.tierColor = this.tier.getColor();
    }

    public void setBaseColor(Color4 col) {
        this.baseColor = col;
    }

    public void setCoreColor(Color4 col) {
        this.coreColor = col;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        EnviroUtil.createTierTooltip(this.tier, tooltip);
        StructureMap sl = (StructureMap)this.structureList.request();
        if (sl == null || sl.getStructure(this.tier.getTier()) == null) {
            return;
        }
        QuickTooltips.createConditional((Supplier)QuickTooltips.SHIFT).addFalse(new ITextComponent[]{QuickTooltips.shiftForInfoTooltip()}).addTrue(sl.getStructure(this.tier.getTier()).getRequirements()).buildTo(tooltip);
    }

    public int getColor(IBlockDisplayReader reader, BlockState blockState, BlockPos blockPos, int i) {
        if (i == 2 || reader == null || blockPos == null) {
            return this.tierColor.getRGBA();
        }
        TileEntity te = reader.func_175625_s(blockPos);
        if (te instanceof IColorProviderTile) {
            return ((IColorProviderTile)te).getColor(i);
        }
        return this.tierColor.getRGBA();
    }

    public int getColor(ItemStack itemStack, int i) {
        if (itemStack == null) {
            return this.coreColor.getRGBA();
        }
        CompoundNBT nbt = itemStack.func_179543_a("colors");
        switch (i) {
            case 0: {
                return this.baseColor.getRGBA();
            }
            case 1: {
                return this.coreColor.getRGBA();
            }
        }
        return this.tierColor.getRGBA();
    }

    public void loadColors(IConfig config) {
        this.loadColors(config, this.baseColor, this.coreColor);
    }

    public void loadColors(IConfig config, int r, int g, int b, int r2, int g2, int b2) {
        this.loadColors(config, new Color4(r, g, b), new Color4(r2, g2, b2));
    }

    public void loadColors(IConfig config, Color4 base, Color4 core) {
        IConfig baseCFG = config.getSubConfig("default_base_color");
        this.setBaseColor(new Color4(baseCFG.getInt("r", base.getRi(), 0, 255, new String[0]), baseCFG.getInt("g", base.getGi(), 0, 255, new String[0]), baseCFG.getInt("b", base.getBi(), 0, 255, new String[0])));
        IConfig coreCFG = config.getSubConfig("default_core_color");
        this.setCoreColor(new Color4(coreCFG.getInt("r", core.getRi(), 0, 254, new String[0]), coreCFG.getInt("g", core.getGi(), 0, 255, new String[0]), coreCFG.getInt("b", core.getBi(), 0, 255, new String[0])));
    }

    public int[] getAllColorableChannels() {
        return new int[]{0, 1};
    }

    public int[] getAllColorChannels() {
        return new int[]{0, 1, 2};
    }
}

