/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBlockEntity;
import com.supermartijn642.entangled.EntangledConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.joml.Quaternionf;

public class EntangledBlockEntityRenderer
implements CustomBlockEntityRenderer<EntangledBlockEntity> {
    public static final class_6862<class_2248> BLACKLISTED_BLOCKS = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("entangled", "render_blacklist"));
    public static final class_6862<class_2591<?>> BLACKLISTED_ENTITIES = class_6862.method_40092((class_5321)class_7924.field_41255, (class_2960)new class_2960("entangled", "render_blacklist"));
    private static final Set<class_2591<?>> ERRORED_BLOCK_ENTITIES = Collections.synchronizedSet(new HashSet());
    private static final Set<class_2680> ERRORED_BLOCK_STATES = Collections.synchronizedSet(new HashSet());
    private static int depth = 0;

    public void render(EntangledBlockEntity entity, float partialTicks, class_4587 poseStack, class_4597 bufferSource, int combinedLight, int combinedOverlay) {
        class_265 shape;
        if (!entity.isBound()) {
            return;
        }
        class_2586 boundTile = entity.method_10997().method_27983() == entity.getBoundDimensionIdentifier() ? entity.method_10997().method_8321(entity.getBoundBlockPos()) : null;
        class_2680 boundState = entity.getBoundBlockState();
        boolean renderTile = boundTile != null && class_7923.field_41181.method_40266(BLACKLISTED_ENTITIES).map(tag -> tag.method_40241((class_6880)class_7923.field_41181.method_40264(class_5321.method_29179((class_5321)class_7924.field_41255, (class_2960)class_7923.field_41181.method_10221((Object)boundTile.method_11017()))).orElseThrow())).orElse(false) == false && !ERRORED_BLOCK_ENTITIES.contains(boundTile.method_11017());
        boolean renderBlock = boundState != null && boundState.method_26217() == class_2464.field_11458 && !boundState.method_26164(BLACKLISTED_BLOCKS) && !ERRORED_BLOCK_STATES.contains(boundState);
        class_238 bounds = new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (renderBlock && entity.method_10997().method_27983() == entity.getBoundDimensionIdentifier() && !(shape = boundState.method_26201((class_1922)entity.method_10997(), entity.getBoundBlockPos())).method_1110()) {
            bounds = shape.method_1107();
        }
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.5, 0.5);
        if (EntangledConfig.rotateRenderedBlock.get().booleanValue()) {
            float angleX = (float)(System.currentTimeMillis() % 10000L) / 10000.0f * 2.0f * (float)Math.PI;
            float angleY = (float)(System.currentTimeMillis() % 11000L) / 11000.0f * 2.0f * (float)Math.PI;
            float angleZ = (float)(System.currentTimeMillis() % 12000L) / 12000.0f * 2.0f * (float)Math.PI;
            poseStack.method_22907(new Quaternionf().setAngleAxis(angleX, 1.0f, 0.0f, 0.0f));
            poseStack.method_22907(new Quaternionf().setAngleAxis(angleY, 0.0f, 1.0f, 0.0f));
            poseStack.method_22907(new Quaternionf().setAngleAxis(angleZ, 0.0f, 0.0f, 1.0f));
        }
        float scale = 0.4763f / (float)Math.sqrt((bounds.method_17939() * bounds.method_17939() + bounds.method_17940() * bounds.method_17940() + bounds.method_17941() * bounds.method_17941()) / 4.0);
        poseStack.method_22905(scale, scale, scale);
        poseStack.method_22904(-bounds.method_1005().field_1352, -bounds.method_1005().field_1351, -bounds.method_1005().field_1350);
        if (renderTile && (!(boundTile instanceof EntangledBlockEntity) || depth < 10)) {
            ++depth;
            try {
                ClientUtils.getMinecraft().method_31975().method_3555(boundTile, partialTicks, poseStack, bufferSource);
            }
            catch (Exception e) {
                ERRORED_BLOCK_ENTITIES.add(boundTile.method_11017());
                Entangled.LOGGER.error("Encountered an exception whilst rendering block entity '" + Registries.BLOCK_ENTITY_TYPES.getIdentifier((Object)boundTile.method_11017()) + "'! Please report to Entangled!", (Throwable)e);
            }
            --depth;
        }
        if (renderBlock) {
            try {
                ClientUtils.getBlockRenderer().method_3353(boundState, poseStack, bufferSource, combinedLight, combinedOverlay);
            }
            catch (Exception e) {
                ERRORED_BLOCK_STATES.add(boundState);
                Entangled.LOGGER.error("Encountered an exception whilst rendering block '" + boundState + "'! Please report to Entangled!", (Throwable)e);
            }
        }
        poseStack.method_22909();
    }
}

