/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.entangled.Entangled;
import com.supermartijn642.entangled.EntangledBinderItem;
import com.supermartijn642.entangled.EntangledBlockEntity;
import com.supermartijn642.entangled.EntangledConfig;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class EntangledBlock
extends BaseBlock
implements EntityHoldingBlock {
    public static final class_2754<State> STATE_PROPERTY = class_2754.method_11850((String)"state", State.class);

    public static boolean canBindTo(class_2960 blockDimension, class_2338 blockPosition, class_2960 targetDimension, class_2338 targetPosition) {
        if (CommonUtils.getLevel((class_5321)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)targetDimension)) == null) {
            return false;
        }
        if (!blockDimension.equals((Object)targetDimension)) {
            return EntangledConfig.allowDimensional.get();
        }
        if (blockPosition.equals((Object)targetPosition)) {
            return false;
        }
        int maxDistance = EntangledConfig.maxDistance.get();
        return maxDistance == -1 || blockPosition.method_19771((class_2382)targetPosition, (double)maxDistance + 0.5);
    }

    public EntangledBlock() {
        super(true, BlockProperties.create().mapColor(class_3620.field_15977).sound(class_2498.field_11544).destroyTime(1.0f).explosionResistance(2.0f).noOcclusion());
        this.method_9590((class_2680)this.method_9564().method_11657(STATE_PROPERTY, (Comparable)((Object)State.UNBOUND)));
    }

    protected BaseBlock.InteractionFeedback interact(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_2350 hitSide, class_243 hitLocation) {
        class_2586 entity = level.method_8321(pos);
        if (!(entity instanceof EntangledBlockEntity)) {
            return BaseBlock.InteractionFeedback.PASS;
        }
        class_1799 stack = player.method_5998(hand);
        if (player.method_18276() && stack.method_7960() && ((EntangledBlockEntity)entity).isBound()) {
            if (!level.field_9236) {
                ((EntangledBlockEntity)entity).unbind();
                player.method_7353((class_2561)TextComponents.translation((String)"entangled.entangled_block.unbind").color(class_124.field_1054).get(), true);
            }
            return BaseBlock.InteractionFeedback.SUCCESS;
        }
        if (stack.method_7909() == Entangled.item) {
            if (!level.field_9236) {
                if (EntangledBinderItem.isBound(stack)) {
                    class_2960 targetDimension = EntangledBinderItem.getBoundDimension(stack);
                    class_2338 targetPos = EntangledBinderItem.getBoundPosition(stack);
                    if (EntangledBlock.canBindTo(level.method_27983().method_29177(), pos, targetDimension, targetPos)) {
                        ((EntangledBlockEntity)entity).bind(targetPos, targetDimension);
                        player.method_7353((class_2561)TextComponents.translation((String)"entangled.entangled_block.bind").color(class_124.field_1054).get(), true);
                    } else if (CommonUtils.getLevel((class_5321)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)targetDimension)) == null) {
                        player.method_7353((class_2561)TextComponents.translation((String)"entangled.entangled_binder.unknown_dimension", (Object[])new Object[]{targetDimension}).color(class_124.field_1061).get(), true);
                    } else if (!level.method_27983().method_29177().equals((Object)targetDimension) && !EntangledConfig.allowDimensional.get().booleanValue()) {
                        player.method_7353((class_2561)TextComponents.translation((String)"entangled.entangled_block.wrong_dimension").color(class_124.field_1061).get(), true);
                    } else if (pos.equals((Object)targetPos)) {
                        player.method_7353((class_2561)TextComponents.translation((String)"entangled.entangled_block.self").color(class_124.field_1061).get(), true);
                    } else {
                        player.method_7353((class_2561)TextComponents.translation((String)"entangled.entangled_block.too_far").color(class_124.field_1061).get(), true);
                    }
                } else {
                    player.method_7353((class_2561)TextComponents.translation((String)"entangled.entangled_block.no_selection").color(class_124.field_1061).get(), true);
                }
            }
            return BaseBlock.InteractionFeedback.SUCCESS;
        }
        return BaseBlock.InteractionFeedback.PASS;
    }

    public class_2586 createNewBlockEntity(class_2338 pos, class_2680 state) {
        return new EntangledBlockEntity(pos, state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{STATE_PROPERTY});
    }

    public class_265 method_26159(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return ((State)((Object)state.method_11654(STATE_PROPERTY))).isBound() ? class_259.method_1073() : class_259.method_1077();
    }

    protected void appendItemInformation(class_1799 stack, @Nullable class_1922 level, Consumer<class_2561> info, boolean advanced) {
        String key = EntangledConfig.allowDimensional.get().booleanValue() ? (EntangledConfig.maxDistance.get() == -1 ? "infinite_other_dimension" : "ranged_other_dimension") : (EntangledConfig.maxDistance.get() == -1 ? "infinite_same_dimension" : "ranged_same_dimension");
        class_5250 maxDistance = TextComponents.string((String)Integer.toString(EntangledConfig.maxDistance.get())).color(class_124.field_1065).get();
        info.accept((class_2561)TextComponents.translation((String)("entangled.entangled_block.info." + key), (Object[])new Object[]{maxDistance}).color(class_124.field_1075).get());
        class_2487 tag = stack.method_7948().method_10562("tileData");
        if (tag.method_10545("bound") && tag.method_10577("bound")) {
            int x = tag.method_10550("boundx");
            int y = tag.method_10550("boundy");
            int z = tag.method_10550("boundz");
            class_5250 dimension = TextComponents.dimension((class_5321)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(tag.method_10558("dimension")))).color(class_124.field_1065).get();
            class_5250 name = TextComponents.blockState((class_2680)class_2248.method_9531((int)tag.method_10550("blockstate"))).color(class_124.field_1065).get();
            class_5250 xText = TextComponents.string((String)Integer.toString(x)).color(class_124.field_1065).get();
            class_5250 yText = TextComponents.string((String)Integer.toString(y)).color(class_124.field_1065).get();
            class_5250 zText = TextComponents.string((String)Integer.toString(z)).color(class_124.field_1065).get();
            info.accept((class_2561)TextComponents.translation((String)"entangled.entangled_block.info.bound", (Object[])new Object[]{name, xText, yText, zText, dimension}).color(class_124.field_1054).get());
        }
    }

    public class_2680 method_9605(class_1750 context) {
        class_1799 stack = context.method_8041();
        class_2487 compound = stack.method_7948().method_10562("tileData");
        if (compound.method_10577("bound")) {
            class_2338 targetPos;
            class_2960 targetDimension;
            class_2338 placePos;
            class_2960 placeDimension = context.method_8045().method_27983().method_29177();
            if (!EntangledBlock.canBindTo(placeDimension, placePos = context.method_8037(), targetDimension = EntangledBinderItem.getBoundDimension(stack), targetPos = EntangledBinderItem.getBoundPosition(stack))) {
                class_1657 player = context.method_8036();
                if (player != null) {
                    if (CommonUtils.getLevel((class_5321)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)targetDimension)) == null) {
                        player.method_7353((class_2561)TextComponents.translation((String)"entangled.entangled_binder.unknown_dimension", (Object[])new Object[]{targetDimension}).color(class_124.field_1061).get(), true);
                    } else if (!placeDimension.equals((Object)targetDimension) && !EntangledConfig.allowDimensional.get().booleanValue()) {
                        player.method_7353((class_2561)TextComponents.translation((String)"entangled.entangled_block.wrong_dimension").color(class_124.field_1061).get(), true);
                    } else if (placePos.equals((Object)targetPos)) {
                        player.method_7353((class_2561)TextComponents.translation((String)"entangled.entangled_block.self").color(class_124.field_1061).get(), true);
                    } else {
                        player.method_7353((class_2561)TextComponents.translation((String)"entangled.entangled_block.too_far").color(class_124.field_1061).get(), true);
                    }
                }
                return null;
            }
            return (class_2680)this.method_9564().method_11657(STATE_PROPERTY, (Comparable)((Object)State.BOUND_VALID));
        }
        return this.method_9564();
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 entity = world.method_8321(pos);
        return entity instanceof EntangledBlockEntity ? ((EntangledBlockEntity)entity).getAnalogOutputSignal() : 0;
    }

    public boolean method_9506(class_2680 state) {
        return true;
    }

    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        class_2586 entity = world.method_8321(pos);
        return entity instanceof EntangledBlockEntity ? ((EntangledBlockEntity)entity).getRedstoneSignal(direction) : 0;
    }

    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        class_2586 entity = world.method_8321(pos);
        return entity instanceof EntangledBlockEntity ? ((EntangledBlockEntity)entity).getDirectRedstoneSignal(direction) : 0;
    }

    public static enum State implements class_3542
    {
        UNBOUND,
        BOUND_VALID,
        BOUND_INVALID;


        public boolean isBound() {
            return this != UNBOUND;
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

