/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import com.supermartijn642.entangled.EntangledBinderItem;
import com.supermartijn642.entangled.EntangledBlock;
import com.supermartijn642.entangled.EntangledBlockApiProviders;
import com.supermartijn642.entangled.EntangledBlockEntity;
import com.supermartijn642.entangled.generators.EntangledBlockStateGenerator;
import com.supermartijn642.entangled.generators.EntangledLanguageGenerator;
import com.supermartijn642.entangled.generators.EntangledLootTableGenerator;
import com.supermartijn642.entangled.generators.EntangledModelGenerator;
import com.supermartijn642.entangled.generators.EntangledRecipeGenerator;
import com.supermartijn642.entangled.generators.EntangledTagGenerator;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2248;
import org.slf4j.Logger;

public class Entangled
implements ModInitializer {
    public static final Logger LOGGER = CommonUtils.getLogger((String)"entangled");
    @RegistryEntryAcceptor(namespace="entangled", identifier="block", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static EntangledBlock block;
    @RegistryEntryAcceptor(namespace="entangled", identifier="tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<EntangledBlockEntity> tile;
    @RegistryEntryAcceptor(namespace="entangled", identifier="item", registry=RegistryEntryAcceptor.Registry.ITEMS)
    public static EntangledBinderItem item;

    public void onInitialize() {
        Entangled.register();
        Entangled.registerGenerators();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"entangled");
        handler.registerBlock("block", EntangledBlock::new);
        handler.registerItem("block", () -> new BaseBlockItem((class_2248)block, ItemProperties.create().group(CreativeItemGroup.getFunctionalBlocks())));
        handler.registerBlockEntityType("tile", () -> BaseBlockEntityType.create(EntangledBlockEntity::new, (class_2248[])new class_2248[]{block}));
        handler.registerBlockEntityTypeCallback(helper -> EntangledBlockApiProviders.register());
        handler.registerItem("item", EntangledBinderItem::new);
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"entangled");
        handler.addGenerator(EntangledBlockStateGenerator::new);
        handler.addGenerator(EntangledModelGenerator::new);
        handler.addGenerator(EntangledLanguageGenerator::new);
        handler.addGenerator(EntangledLootTableGenerator::new);
        handler.addGenerator(EntangledRecipeGenerator::new);
        handler.addGenerator(EntangledTagGenerator::new);
    }
}

