/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.entangled.integration;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.entangled.EntangledBlock;
import com.supermartijn642.entangled.EntangledBlockTile;
import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

@WailaPlugin(value="entangled")
public class EntangledWailaPlugin
implements IComponentProvider,
IWailaPlugin {
    public void register(IRegistrar registrar) {
        registrar.registerComponentProvider((IComponentProvider)this, TooltipPosition.BODY, EntangledBlock.class);
    }

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        TileEntity tile = accessor.getTileEntity();
        if (tile instanceof EntangledBlockTile) {
            if (((EntangledBlockTile)tile).isBound()) {
                BlockState boundBlockState = ((EntangledBlockTile)tile).getBoundBlockState();
                IFormattableTextComponent boundBlock = (boundBlockState == null ? TextComponents.string((String)"Block") : TextComponents.blockState((BlockState)boundBlockState)).color(TextFormatting.GOLD).get();
                BlockPos boundPos = ((EntangledBlockTile)tile).getBoundBlockPos();
                IFormattableTextComponent x = TextComponents.string((String)Integer.toString(boundPos.func_177958_n())).color(TextFormatting.GOLD).get();
                IFormattableTextComponent y = TextComponents.string((String)Integer.toString(boundPos.func_177956_o())).color(TextFormatting.GOLD).get();
                IFormattableTextComponent z = TextComponents.string((String)Integer.toString(boundPos.func_177952_p())).color(TextFormatting.GOLD).get();
                if (((EntangledBlockTile)tile).getBoundDimension() == accessor.getWorld().func_234923_W_()) {
                    tooltip.add((ITextComponent)TextComponents.translation((String)"entangled.waila.bound_same_dimension", (Object[])new Object[]{boundBlock, x, y, z}).color(TextFormatting.YELLOW).get());
                } else {
                    IFormattableTextComponent dimension = TextComponents.dimension(((EntangledBlockTile)tile).getBoundDimension()).color(TextFormatting.GOLD).get();
                    tooltip.add((ITextComponent)TextComponents.translation((String)"entangled.waila.bound_other_dimension", (Object[])new Object[]{boundBlock, x, y, z, dimension}).color(TextFormatting.YELLOW).get());
                }
            } else {
                tooltip.add((ITextComponent)TextComponents.translation((String)"entangled.waila.unbound").color(TextFormatting.YELLOW).get());
            }
        }
    }
}

