/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.libmc.detail;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import wile.engineerstools.libmc.detail.Auxiliaries;

public class ExtendedShapelessRecipe
extends ShapelessRecipe
implements ICraftingRecipe {
    public static final Serializer SERIALIZER = (Serializer)new Serializer().setRegistryName(Auxiliaries.modid(), "crafting_extended_shapeless");
    private final CompoundNBT aspects;
    private final ResourceLocation resultTag;

    public ExtendedShapelessRecipe(ResourceLocation id, String group, ItemStack output, NonNullList<Ingredient> ingredients, CompoundNBT aspects, ResourceLocation resultTag) {
        super(id, group, output, ingredients);
        this.aspects = aspects;
        this.resultTag = resultTag;
    }

    public CompoundNBT getAspects() {
        return this.aspects.func_74737_b();
    }

    private int getToolDamage() {
        if (this.aspects.func_74764_b("tool_repair")) {
            return -MathHelper.func_76125_a((int)this.aspects.func_74762_e("tool_repair"), (int)0, (int)4096);
        }
        if (this.aspects.func_74764_b("tool_damage")) {
            return MathHelper.func_76125_a((int)this.aspects.func_74762_e("tool_damage"), (int)1, (int)1024);
        }
        return 0;
    }

    private boolean isRepair() {
        return this.getToolDamage() < 0;
    }

    public boolean func_192399_d() {
        return this.isRepair() || this.aspects.func_74767_n("dynamic");
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        String tool_name = this.aspects.func_74779_i("tool");
        int tool_damage = this.getToolDamage();
        NonNullList remaining = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remaining.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b().getRegistryName().toString().equals(tool_name)) {
                if (!stack.func_77984_f()) {
                    remaining.set(i, (Object)stack);
                    continue;
                }
                if (this.isRepair()) continue;
                ItemStack rstack = stack.func_77946_l();
                rstack.func_196085_b(rstack.func_77952_i() + tool_damage);
                if (rstack.func_77952_i() >= rstack.func_77958_k()) continue;
                remaining.set(i, (Object)rstack);
                continue;
            }
            if (!stack.hasContainerItem()) continue;
            remaining.set(i, (Object)stack.getContainerItem());
        }
        return remaining;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        if (!this.isRepair()) {
            return super.func_77572_b(inv);
        }
        String tool_name = this.aspects.func_74779_i("tool");
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!stack.func_77973_b().getRegistryName().toString().equals(tool_name)) continue;
            ItemStack rstack = stack.func_77946_l();
            int dmg = rstack.func_77952_i();
            int repair_negative_dmg = Math.min(-1, this.getToolDamage() * rstack.func_77958_k() / 100);
            rstack.func_196085_b(Math.max(dmg + repair_negative_dmg, 0));
            if (rstack.func_77973_b() instanceof IRepairableToolItem) {
                rstack = ((IRepairableToolItem)rstack.func_77973_b()).onShapelessRecipeRepaired(rstack, dmg, rstack.func_77952_i());
            }
            return rstack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_77571_b() {
        return this.func_192399_d() ? ItemStack.field_190927_a : super.func_77571_b();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ExtendedShapelessRecipe> {
        private static int MAX_WIDTH = 3;
        private static int MAX_HEIGHT = 3;

        public ExtendedShapelessRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject res;
            JsonObject aspects;
            ResourceLocation resultTag = new ResourceLocation("libmc", "none");
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList list = NonNullList.func_191196_a();
            JsonArray ingredients = JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredients.get(i));
                if (ingredient.func_203189_d()) continue;
                list.add((Object)ingredient);
            }
            if (list.isEmpty()) {
                throw new JsonParseException("No ingredients for " + this.getRegistryName().func_110623_a() + " recipe");
            }
            if (list.size() > MAX_WIDTH * MAX_HEIGHT) {
                throw new JsonParseException("Too many ingredients for crafting_tool_shapeless recipe the max is " + MAX_WIDTH * MAX_HEIGHT);
            }
            CompoundNBT aspects_nbt = new CompoundNBT();
            if (json.get("aspects") != null && (aspects = JSONUtils.func_152754_s((JsonObject)json, (String)"aspects")).size() > 0) {
                try {
                    aspects_nbt = JsonToNBT.func_180713_a((String)new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson((JsonElement)aspects));
                }
                catch (Exception ex) {
                    throw new JsonParseException(this.getRegistryName().func_110623_a() + ": Failed to parse the 'aspects' object:" + ex.getMessage());
                }
            }
            if ((res = JSONUtils.func_152754_s((JsonObject)json, (String)"result")).has("tag")) {
                ResourceLocation rl = new ResourceLocation(res.get("tag").getAsString());
                ITag tag = TagCollectionManager.func_242178_a().func_241836_b().func_241833_a().getOrDefault(rl, null);
                if (tag == null) {
                    throw new JsonParseException(this.getRegistryName().func_110623_a() + ": Result tag does not exist: #" + rl);
                }
                if (tag.func_230236_b_().isEmpty()) {
                    throw new JsonParseException(this.getRegistryName().func_110623_a() + ": Result tag has no items: #" + rl);
                }
                if (res.has("item")) {
                    res.remove("item");
                }
                resultTag = rl;
                ArrayList lst = Lists.newArrayList((Iterable)tag.func_230236_b_());
                res.addProperty("item", ((Item)lst.get(0)).getRegistryName().toString());
            }
            ItemStack result_stack = ShapedRecipe.func_199798_a((JsonObject)res);
            return new ExtendedShapelessRecipe(recipeId, group, result_stack, (NonNullList<Ingredient>)list, aspects_nbt, resultTag);
        }

        public ExtendedShapelessRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer pkt) {
            String group = pkt.func_150789_c(Short.MAX_VALUE);
            int size = pkt.func_150792_a();
            NonNullList list = NonNullList.func_191197_a((int)size, (Object)Ingredient.field_193370_a);
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)pkt));
            }
            ItemStack stack = pkt.func_150791_c();
            CompoundNBT aspects = pkt.func_150793_b();
            ResourceLocation resultTag = pkt.func_192575_l();
            return new ExtendedShapelessRecipe(recipeId, group, stack, (NonNullList<Ingredient>)list, aspects, resultTag);
        }

        public void toNetwork(PacketBuffer pkt, ExtendedShapelessRecipe recipe) {
            pkt.func_180714_a(recipe.func_193358_e());
            pkt.func_150787_b(recipe.func_192400_c().size());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(pkt);
            }
            pkt.func_150788_a(recipe.func_77571_b());
            pkt.func_150786_a(recipe.getAspects());
            pkt.func_192572_a(recipe.resultTag);
        }
    }

    public static interface IRepairableToolItem {
        public ItemStack onShapelessRecipeRepaired(ItemStack var1, int var2, int var3);
    }
}

