/*
 * Decompiled with CFR 0.152.
 */
package wile.engineerstools.libmc.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import wile.engineerstools.libmc.blocks.StandardBlocks;
import wile.engineerstools.libmc.detail.Auxiliaries;

public class LootTableGen
extends LootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator generator;
    private final Supplier<List<Block>> block_listing;

    public LootTableGen(DataGenerator gen, Supplier<List<Block>> block_list_supplier) {
        super(gen);
        this.generator = gen;
        this.block_listing = block_list_supplier;
    }

    public String func_200397_b() {
        return Auxiliaries.modid() + " Loot Tables";
    }

    public void func_200398_a(DirectoryCache cache) {
        this.save(cache, this.generate());
    }

    private Map<ResourceLocation, LootTable> generate() {
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        List<Block> blocks = this.block_listing.get();
        blocks.forEach(block -> {
            if (!(block instanceof StandardBlocks.IStandardBlock) || !((StandardBlocks.IStandardBlock)block).hasDynamicDropList()) {
                tables.put(block.func_220068_i(), this.defaultBlockDrops(block.getRegistryName().func_110623_a() + "_dlt", (Block)block).func_216039_a(LootParameterSets.field_216267_h).func_216038_b());
            }
        });
        return tables;
    }

    private void save(DirectoryCache cache, Map<ResourceLocation, LootTable> tables) {
        Path root = this.generator.func_200391_b();
        tables.forEach((rl, tab) -> {
            Path fp = root.resolve("data/" + rl.func_110624_b() + "/loot_tables/" + rl.func_110623_a() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)tab), (Path)fp);
            }
            catch (Exception e) {
                LOGGER.error("Failed to save loottable '" + fp + "', exception: " + e);
            }
        });
    }

    private LootTable.Builder defaultBlockDrops(String rl_path, Block block) {
        StandaloneLootEntry.Builder iltb = ItemLootEntry.func_216168_a((IItemProvider)block);
        iltb.func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY));
        if (block.hasTileEntity(block.func_176223_P())) {
            iltb.func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY));
        }
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name(rl_path).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)iltb));
    }
}

