/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.data.INBTSerializable;
import com.endertech.minecraft.forge.data.INetSerializable;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.DimensionId;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ChunkLoc
implements INetSerializable<ChunkLoc>,
INBTSerializable<ChunkLoc> {
    public static final ChunkLoc ZERO = new ChunkLoc(DimensionId.from((RegistryKey<World>)World.field_234918_g_), new ChunkPos(0, 0));
    private final DimensionId dimensionId;
    private final ChunkPos pos;
    private final ChunkBounds bounds;

    public ChunkLoc(DimensionId dimensionId, ChunkPos pos) {
        this.pos = pos;
        this.dimensionId = dimensionId;
        this.bounds = ChunkBounds.from(pos);
    }

    public static ChunkLoc from(World world, ChunkPos pos) {
        return new ChunkLoc(DimensionId.from(world), pos);
    }

    public static ChunkLoc from(Chunk chunk) {
        return ChunkLoc.from(chunk.func_177412_p(), chunk.func_76632_l());
    }

    public DimensionId getDimensionId() {
        return this.dimensionId;
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public ChunkBounds getBounds() {
        return this.bounds;
    }

    public boolean existsIn(World world) {
        return world.func_217354_b(this.getPos().field_77276_a, this.getPos().field_77275_b);
    }

    public Optional<Chunk> getChunk(World world) {
        return this.existsIn(world) ? Optional.of(world.func_212866_a_(this.getPos().field_77276_a, this.getPos().field_77275_b)) : Optional.empty();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChunkLoc) {
            ChunkLoc that = (ChunkLoc)obj;
            return this.getDimensionId().equals(that.getDimensionId()) && this.getPos().equals((Object)that.getPos());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getPos(), this.getDimensionId());
    }

    public boolean contains(Entity entity) {
        return this.getDimensionId().belongsTo(entity.field_70170_p) && this.getBounds().encloses(entity.func_233580_cy_());
    }

    public String toString() {
        return ChunkLoc.class.getSimpleName() + Args.group(Args.get("pos", this.getPos()), Args.get("dimensionId", this.getDimensionId()));
    }

    @Override
    public ChunkLoc readFrom(PacketBuffer buf) {
        return new ChunkLoc(DimensionId.from(buf.func_192575_l()), new ChunkPos(buf.readInt(), buf.readInt()));
    }

    @Override
    public PacketBuffer writeTo(PacketBuffer buf) {
        buf.func_192572_a(this.getDimensionId().toResourceLocation());
        buf.writeInt(this.getPos().field_77276_a);
        buf.writeInt(this.getPos().field_77275_b);
        return buf;
    }

    @Override
    public ChunkLoc readFrom(CompoundNBT compound) {
        CompoundNBT tag = compound.func_74775_l("ChunkLoc");
        DimensionId id = DimensionId.from(new ResourceLocation(tag.func_74779_i("id")));
        ChunkPos pos = new ChunkPos(tag.func_74763_f("pos"));
        return new ChunkLoc(id, pos);
    }

    @Override
    public CompoundNBT writeTo(CompoundNBT compound) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("id", this.getDimensionId().toResourceLocation().toString());
        tag.func_74772_a("pos", this.getPos().func_201841_a());
        compound.func_218657_a("ChunkLoc", (INBT)tag);
        return compound;
    }
}

