/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.common.CommonArray;
import com.endertech.common.CommonPath;
import com.endertech.common.CommonString;
import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.blocks.BlockStatesSet;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class UnitId {
    public static final UnitId EMPTY = UnitId.from("", "");
    public static final String FORMAT_FULL = "<modId:unitName:meta>";
    public static final String DESCRIPTION = "Id is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUse '*' char or '[]' as meta value to specify all possible values (all block states).\nTo define multiple block states, you can use block properties. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use tags. The format is <#modId:tagPath> (example: #forge:ores/copper).\n";
    public static final String DELIMITER = ":";
    public static final String TAG = "#";
    public static final String MOD_ID_MINECRAFT = "minecraft";
    public static final String REG_NAME_WORDS_DELIMITER = "_";
    public static final String UNLOCALIZED_NAME_DELIMITER = ".";
    public static final String INCODE_DELIMITER = "$";
    public static final Pattern PATTERN = Pattern.compile("^(?<tag>@|#)?(?:(?<modid>[a-z0-9_.-]+):)?(?<unitname>[a-z0-9/._-]+)(?::(?<metadata>\\*|\\[.*\\]))?$");
    public static final String PROPS_OPENING_BRACKET = "[";
    public static final String PROPS_CLOSING_BRACKET = "]";
    public static final String PROPS_DELIMITER = ",";
    public static final int META_DEFAULT = 0;
    public static final int META_ALL_INT = Short.MAX_VALUE;
    public static final String META_EMPTY = "";
    public static final String META_ALL_CHAR = "*";
    public static final String META_EMPTY_PROPS = "[]";
    private final String modId;
    private final String regName;
    private final String metadata;
    private final boolean isTag;
    protected final Cache cache = new Cache();

    public UnitId(String modId, String regName, String metadata, boolean isTag) {
        this.modId = modId;
        this.regName = regName;
        this.metadata = metadata;
        this.isTag = isTag;
    }

    public static String joinWords(String delimiter, String ... words) {
        ArrayList<String> wordsList = new ArrayList<String>();
        for (String word : words) {
            if ((word = word.trim()).isEmpty()) continue;
            wordsList.add(word);
        }
        return String.join((CharSequence)delimiter, wordsList);
    }

    public static String[] capitalizeWords(String ... words) {
        String[] capitalizedWords = new String[words.length];
        for (int i = 0; i < capitalizedWords.length; ++i) {
            capitalizedWords[i] = CommonString.capitalizeFirstChar(words[i]);
        }
        return capitalizedWords;
    }

    public static String buildRegName(String ... nameWords) {
        return UnitId.joinWords(REG_NAME_WORDS_DELIMITER, nameWords).toLowerCase(Locale.ROOT);
    }

    public static String buildDictName(String ... nameWords) {
        nameWords = UnitId.capitalizeWords(nameWords);
        String dictName = String.join((CharSequence)META_EMPTY, nameWords);
        dictName = CommonString.decapitalizeFirstChar(dictName);
        return dictName;
    }

    public static String[] splitRegName(String regName, boolean capitalizeWords, boolean invertOrder) {
        String[] nameWords = regName.split(REG_NAME_WORDS_DELIMITER);
        if (capitalizeWords) {
            nameWords = UnitId.capitalizeWords(nameWords);
        }
        if (invertOrder) {
            CommonArray.reverse(nameWords);
        }
        return nameWords;
    }

    public static String[] splitDictName(String dictName) {
        ArrayList<String> wordsList = new ArrayList<String>();
        int wordStartsAt = 0;
        for (int i = 0; i < dictName.length(); ++i) {
            char ch = dictName.charAt(i);
            if (Character.isUpperCase(ch) && i != 0) {
                String word = dictName.substring(wordStartsAt, i);
                wordsList.add(word);
                wordStartsAt = i;
            }
            if (i != dictName.length() - 1) continue;
            String lastWord = dictName.substring(wordStartsAt);
            wordsList.add(lastWord);
        }
        return wordsList.toArray(new String[0]);
    }

    public static String regToDictName(String regName) {
        String[] nameWords = UnitId.splitRegName(regName, true, true);
        String dictName = UnitId.buildDictName(nameWords);
        return dictName;
    }

    public static String dictToRegName(String dictName) {
        String[] nameWords = UnitId.splitDictName(dictName);
        return UnitId.buildRegName(nameWords);
    }

    public static boolean isNullOrEmpty(UnitId unitId) {
        return unitId == null || unitId.isEmpty();
    }

    public boolean isEmpty() {
        return CommonString.isNullOrEmpty(this.getModId()) || CommonString.isNullOrEmpty(this.getRegName());
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    public boolean isTag() {
        return this.isTag;
    }

    public static UnitId from(String id) {
        if ((id = id.trim()).isEmpty() || id.equals(DELIMITER)) {
            return EMPTY;
        }
        Matcher matcher = PATTERN.matcher(id);
        if (matcher.matches()) {
            String metadata;
            String unitName;
            String tag = matcher.group("tag");
            boolean isTag = !CommonString.isNullOrEmpty(tag);
            String modId = matcher.group("modid");
            if (modId == null) {
                modId = MOD_ID_MINECRAFT;
            }
            if ((unitName = matcher.group("unitname")) == null) {
                unitName = "null";
            }
            if ((metadata = matcher.group("metadata")) == null) {
                metadata = META_EMPTY;
            }
            return new UnitId(modId, unitName, metadata, isTag);
        }
        ForgeEndertech.getInstance().getLogger().error("Unable to parse '{}'. Invalid id format", (Object)id);
        return EMPTY;
    }

    public static UnitId from(Enum<?> e, String metadata) {
        String stringId = e instanceof IForgeEnum ? ((IForgeEnum)((Object)e)).getName() : e.name();
        stringId = stringId.replace(INCODE_DELIMITER, DELIMITER);
        return UnitId.from(stringId).withMetaData(metadata);
    }

    public static UnitId from(Path path) {
        String stringId = CommonPath.getFileNameOnly(path).replace(INCODE_DELIMITER, DELIMITER);
        return UnitId.from(stringId);
    }

    public static UnitId from(String modId, String ... nameWords) {
        return UnitId.from(modId, UnitId.buildRegName(nameWords));
    }

    public static UnitId from(String modId, String unitName) {
        return new UnitId(modId, unitName, META_EMPTY, false);
    }

    public static UnitId from(String modId, String unitName, int meta) {
        switch (meta) {
            case 0: {
                return new UnitId(modId, unitName, META_EMPTY, false);
            }
            case 32767: {
                return new UnitId(modId, unitName, META_ALL_CHAR, false);
            }
        }
        return new UnitId(modId, unitName, String.valueOf(meta), false);
    }

    public static UnitId from(ResourceLocation location, String metadata) {
        return new UnitId(location.func_110624_b(), location.func_110623_a(), metadata, false);
    }

    public static UnitId from(ResourceLocation location) {
        return UnitId.from(location, META_EMPTY);
    }

    public static UnitId from(Item item) {
        IForgeRegistry registry = ForgeRegistries.ITEMS;
        return registry.containsValue((IForgeRegistryEntry)item) ? UnitId.from(registry.getKey((IForgeRegistryEntry)item)) : EMPTY;
    }

    public static UnitId from(Block block, String metadata) {
        IForgeRegistry registry = ForgeRegistries.BLOCKS;
        return registry.containsValue((IForgeRegistryEntry)block) ? UnitId.from(registry.getKey((IForgeRegistryEntry)block), metadata) : EMPTY;
    }

    public static UnitId from(Block block) {
        return UnitId.from(block, META_EMPTY);
    }

    public static UnitId from(BlockState state) {
        return UnitId.from(state.func_177230_c(), UnitId.statePropsAsString(state));
    }

    public static UnitId from(Fluid fluid, String metadata) {
        IForgeRegistry registry = ForgeRegistries.FLUIDS;
        return registry.containsValue((IForgeRegistryEntry)fluid) ? UnitId.from(registry.getKey((IForgeRegistryEntry)fluid), metadata) : EMPTY;
    }

    public static UnitId from(FluidState state) {
        return UnitId.from(state.func_206886_c(), UnitId.statePropsAsString(state));
    }

    public static String statePropsAsString(StateHolder<?, ?> state) {
        StringBuilder builder = new StringBuilder();
        if (!state.func_206871_b().isEmpty()) {
            builder.append(PROPS_OPENING_BRACKET);
            builder.append(state.func_206871_b().entrySet().stream().map(entry -> ((Property)entry.getKey()).func_177701_a() + "=" + entry.getValue()).collect(Collectors.joining(PROPS_DELIMITER)));
            builder.append(PROPS_CLOSING_BRACKET);
        }
        return builder.toString();
    }

    public String getMetaData() {
        return this.metadata;
    }

    protected <E extends ForgeRegistryEntry<E>> E getEntryOrNull(IForgeRegistry<E> registry) {
        ResourceLocation key = this.toResLoc();
        if (registry.containsKey(key)) {
            return (E)((ForgeRegistryEntry)registry.getValue(key));
        }
        return null;
    }

    @Nullable
    public BlockState getFirstMatchedState() {
        if (this.cache.blockState != null) {
            return this.cache.blockState;
        }
        if (this.isTag()) {
            Iterator iter;
            ITagCollection collection = BlockTags.func_199896_a();
            ITag tag = collection.func_199910_a(this.toResLoc());
            if (tag != null && (iter = tag.func_230236_b_().iterator()).hasNext()) {
                this.cache.blockState = ((Block)iter.next()).func_176223_P();
            }
        } else {
            Block block = (Block)this.getEntryOrNull(ForgeRegistries.BLOCKS);
            if (block != null) {
                if (this.hasMetaData()) {
                    BlockStatesSet states = this.getAllMatchedBlockStates();
                    if (states != null) {
                        this.cache.blockState = states.getFirstFor(block).orElse(null);
                    }
                } else {
                    this.cache.blockState = block.func_176223_P();
                }
            }
        }
        return this.cache.blockState;
    }

    public AbstractBlock.Properties getBlockProperties() {
        BlockState state = this.getFirstMatchedState();
        Block block = state != null ? state.func_177230_c() : Blocks.field_150350_a;
        return AbstractBlock.Properties.func_200950_a((AbstractBlock)block);
    }

    protected BlockStatesSet generateAllMatchedStates(Block block, List<KeyValuePair> props) {
        BlockStatesSet allStatesSet = new BlockStatesSet();
        HashMap properties = new HashMap();
        StateContainer container = block.func_176194_O();
        for (KeyValuePair prop : props) {
            Property property = container.func_185920_a(prop.key);
            if (property == null) continue;
            Optional value = property.func_185929_b(prop.value);
            value.ifPresent(o -> properties.put(property, o));
        }
        for (BlockState state : container.func_177619_a()) {
            boolean match = true;
            for (Map.Entry prop : properties.entrySet()) {
                Comparable value = state.func_177229_b((Property)prop.getKey());
                if (value.equals(prop.getValue())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            allStatesSet.add(state);
        }
        return allStatesSet;
    }

    @Nullable
    public BlockStatesSet getAllMatchedBlockStates() {
        if (this.cache.matchedStates != null) {
            return this.cache.matchedStates;
        }
        if (this.isTag()) {
            ITagCollection collection = BlockTags.func_199896_a();
            ITag tag = collection.func_199910_a(this.toResLoc());
            if (tag != null) {
                this.cache.matchedStates = new BlockStatesSet();
                for (Block block : tag.func_230236_b_()) {
                    this.cache.matchedStates.addAllFor(block);
                }
            }
        } else {
            Block block = (Block)this.getEntryOrNull(ForgeRegistries.BLOCKS);
            if (block != null) {
                if (this.hasProperties()) {
                    this.cache.matchedStates = this.generateAllMatchedStates(block, this.cache.props);
                } else {
                    this.cache.matchedStates = new BlockStatesSet();
                    if (this.hasMetaData()) {
                        if (this.getMetaData().equals(META_ALL_CHAR) || this.getMetaData().equals(META_EMPTY_PROPS)) {
                            this.cache.matchedStates.addAllFor(block);
                        }
                    } else {
                        this.cache.matchedStates.add(block.func_176223_P());
                    }
                }
            }
        }
        return this.cache.matchedStates;
    }

    @Nullable
    public Item getFirstMatchedItem() {
        Iterator<Item> iter;
        if (this.cache.item != null) {
            return this.cache.item;
        }
        Collection<Item> items = this.getAllMatchedItems();
        if (items != null && (iter = items.iterator()).hasNext()) {
            this.cache.item = iter.next();
        }
        return this.cache.item;
    }

    @Nullable
    public Collection<Item> getAllMatchedItems() {
        if (this.cache.matchedItems != null) {
            return this.cache.matchedItems;
        }
        if (this.isTag()) {
            ITagCollection collection = ItemTags.func_199903_a();
            ITag tag = collection.func_199910_a(this.toResLoc());
            if (tag != null) {
                this.cache.matchedItems = Collections.unmodifiableCollection(tag.func_230236_b_());
            }
        } else {
            Item item = (Item)this.getEntryOrNull(ForgeRegistries.ITEMS);
            if (item != null) {
                this.cache.matchedItems = Collections.singletonList(item);
            }
        }
        return this.cache.matchedItems;
    }

    @Nullable
    public Collection<Fluid> getAllMatchedFluids() {
        if (this.cache.matchedFluids != null) {
            return this.cache.matchedFluids;
        }
        if (this.isTag()) {
            ITagCollection collection = FluidTags.func_226157_a_();
            ITag tag = collection.func_199910_a(this.toResLoc());
            if (tag != null) {
                this.cache.matchedFluids = Collections.unmodifiableCollection(tag.func_230236_b_());
            }
        } else {
            Fluid fluid = (Fluid)this.getEntryOrNull(ForgeRegistries.FLUIDS);
            if (fluid != null) {
                this.cache.matchedFluids = Collections.singletonList(fluid);
            }
        }
        return this.cache.matchedFluids;
    }

    @Nullable
    public Fluid getFirstMatchedFluid() {
        Iterator<Fluid> iter;
        if (this.cache.fluid != null) {
            return this.cache.fluid;
        }
        Collection<Fluid> fluids = this.getAllMatchedFluids();
        if (fluids != null && (iter = fluids.iterator()).hasNext()) {
            this.cache.fluid = iter.next();
        }
        return this.cache.fluid;
    }

    public UnitId withMetaAll() {
        return this.withMetaData(META_ALL_CHAR);
    }

    public UnitId withMetaData(String metadata) {
        return new UnitId(this.getModId(), this.getRegName(), metadata, this.isTag());
    }

    public UnitId withName(String newName) {
        return new UnitId(this.getModId(), newName, this.getMetaData(), this.isTag());
    }

    public UnitId withName(String ... nameWords) {
        return new UnitId(this.getModId(), UnitId.buildRegName(nameWords), this.getMetaData(), this.isTag());
    }

    public UnitId withNamePrefix(String prefix) {
        return this.withName(prefix, this.getRegName());
    }

    public UnitId withNameSuffix(String suffix) {
        return this.withName(this.getRegName(), suffix);
    }

    public String toString() {
        String result;
        if (this.cache.string != null) {
            return this.cache.string;
        }
        StringJoiner joiner = new StringJoiner(DELIMITER);
        boolean defaultModId = this.getModId().equals(MOD_ID_MINECRAFT);
        if (this.isTag() || !defaultModId) {
            joiner.add(this.getModId());
        }
        joiner.add(this.getRegName());
        if (this.hasMetaData()) {
            joiner.add(this.getMetaData());
        }
        if ((result = joiner.toString()).equals(DELIMITER)) {
            result = META_EMPTY;
        }
        if (this.isTag() && !result.isEmpty()) {
            result = TAG + result;
        }
        this.cache.string = result;
        return this.cache.string;
    }

    public String toConfigName() {
        return this.toResLoc().toString().replace(DELIMITER, INCODE_DELIMITER);
    }

    public ResourceLocation toResLoc() {
        if (this.cache.location == null) {
            this.cache.location = new ResourceLocation(this.getModId(), this.getRegName());
        }
        return this.cache.location;
    }

    public ModelResourceLocation toModelResLoc_Inventory() {
        return this.toModelResLoc("inventory");
    }

    public ModelResourceLocation toModelResLoc_Normal() {
        return this.toModelResLoc(META_EMPTY);
    }

    public ModelResourceLocation toModelResLoc(String variant) {
        return new ModelResourceLocation(this.toResLoc(), variant);
    }

    public boolean equals(Object obj) {
        if (obj instanceof UnitId) {
            UnitId another = (UnitId)obj;
            return this.getModId().equals(another.getModId()) && this.getRegName().equals(another.getRegName()) && this.getMetaData().equals(another.getMetaData());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getModId(), this.getRegName(), this.getMetaData());
    }

    public String getRegName() {
        return this.regName;
    }

    public String getModId() {
        return this.modId;
    }

    public int getMeta() {
        if (this.cache.meta != null) {
            return this.cache.meta;
        }
        this.cache.meta = this.getMetaData().equals(META_ALL_CHAR) ? Integer.valueOf(Short.MAX_VALUE) : (CommonString.allCharsAreDigits(this.metadata) ? Integer.valueOf(this.metadata) : Integer.valueOf(0));
        return this.cache.meta;
    }

    public boolean hasMetaData() {
        return !this.getMetaData().isEmpty();
    }

    public boolean hasProperties() {
        if (this.cache.props == null) {
            this.cache.props = new ArrayList<KeyValuePair>();
            String data = this.getMetaData();
            if (data.startsWith(PROPS_OPENING_BRACKET) && data.endsWith(PROPS_CLOSING_BRACKET)) {
                data = data.substring(1, data.length() - 1);
                for (String elem : data.split(PROPS_DELIMITER)) {
                    KeyValuePair pair = KeyValuePair.from(elem);
                    if (pair.key.isEmpty() || pair.value.isEmpty() || this.cache.props.contains(pair)) continue;
                    this.cache.props.add(pair);
                }
            }
        }
        return !this.cache.props.isEmpty();
    }

    public boolean matches(BlockState state) {
        BlockStatesSet states = this.getAllMatchedBlockStates();
        return states != null && states.contains(state);
    }

    public boolean matches(Item item) {
        Collection<Item> items = this.getAllMatchedItems();
        return items != null && items.contains(item);
    }

    protected static class Cache {
        public BlockState blockState;
        public Item item;
        public Fluid fluid;
        public BlockStatesSet matchedStates;
        public Collection<Item> matchedItems;
        public Collection<Fluid> matchedFluids;
        public List<KeyValuePair> props;
        public ResourceLocation location;
        public String string;
        public Integer meta;

        protected Cache() {
        }
    }

    protected static enum Groups {
        FULL_ID,
        TAG,
        MOD_ID,
        UNIT_NAME,
        METADATA;


        @Nullable
        public String getFrom(Matcher matcher) {
            return matcher.group(this.ordinal());
        }
    }
}

