/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.theoneprobe;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class OneProbeDataProvider
implements IProbeInfoProvider {
    static final OneProbeDataProvider INSTANCE = new OneProbeDataProvider();
    int factoryId;

    public String getID() {
        return "shetiphian.endertanks";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TileEntity tile;
        if (blockState.func_177230_c() instanceof BlockEnderTank && (tile = world.func_175625_s(data.getPos())) instanceof TileEntityEnderTank) {
            probeInfo.element((IElement)new ElementTankInfo((TileEntityEnderTank)tile));
        }
    }

    private static class ElementTankInfo
    implements IElement {
        final CompoundNBT data;
        final List<String> lines = new ArrayList<String>();

        private ElementTankInfo(TileEntityEnderTank tank) {
            List<String> contents = tank.getEnderContainer().getContentsInfo();
            TankInfoHelper.getHUDInfo(this.lines, tank.getOwnerName(), tank.getCode(), tank.getPumpCapacity(), contents);
            this.data = new CompoundNBT();
            this.data.func_74778_a("owner", tank.getOwnerName());
            this.data.func_74778_a("code", tank.getCode());
            this.data.func_74768_a("pump", tank.getPumpCapacity());
            ListNBT listNBT = new ListNBT();
            for (String entry : contents) {
                listNBT.add((Object)StringNBT.func_229705_a_((String)entry));
            }
            this.data.func_218657_a("contents", (INBT)listNBT);
        }

        private ElementTankInfo(CompoundNBT data) {
            if (data == null || data.isEmpty()) {
                this.data = new CompoundNBT();
                return;
            }
            this.data = data;
            ArrayList<String> contents = new ArrayList<String>();
            ListNBT listNBT = data.func_150295_c("contents", 8);
            for (int index = 0; index < listNBT.size(); ++index) {
                contents.add(listNBT.func_150307_f(index));
            }
            TankInfoHelper.getHUDInfo(this.lines, data.func_74779_i("owner"), data.func_74779_i("code"), data.func_74762_e("pump"), contents);
        }

        public void render(MatrixStack matrixStack, int x, int y) {
            for (String line : this.lines) {
                ElementTextRender.render((ITextComponent)new StringTextComponent(line), (MatrixStack)matrixStack, (int)x, (int)y);
                y += 10;
            }
        }

        public int getWidth() {
            int width = 0;
            for (String line : this.lines) {
                width = Math.max(width, ElementTextRender.getWidth((ITextComponent)new StringTextComponent(line)));
            }
            return width;
        }

        public int getHeight() {
            return 10 + (this.lines.size() - 1) * 10;
        }

        public void toBytes(PacketBuffer buffer) {
            buffer.func_150786_a(this.data);
        }

        public int getID() {
            return OneProbeDataProvider.INSTANCE.factoryId;
        }
    }

    static class ElementFactoryTankInfo
    implements IElementFactory {
        ElementFactoryTankInfo() {
        }

        public IElement createElement(PacketBuffer buffer) {
            return new ElementTankInfo(buffer.func_150793_b());
        }
    }
}

