/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.item;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.client.Localization;
import shetiphian.core.common.CapabilityHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.client.render.RenderRegistry;
import shetiphian.endertanks.common.item.EnderFluidHandlerItemStack;
import shetiphian.endertanks.common.misc.CauldronHelper;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class ItemEnderBucket
extends Item
implements IColored {
    public ItemEnderBucket(Item.Properties properties) {
        super(properties);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.OVERRIDES.add((Triple<Item, String, IItemPropertyGetter>)Triple.of((Object)((Object)this), (Object)"type", (stack, world, entity) -> StackHelper.isPublic(stack) ? 0.0f : (StackHelper.isTeam(stack) ? 2.0f : 1.0f))));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> list) {
        if (this.func_194125_a(group)) {
            for (String code : StackHelper.BASE_CODES) {
                list.add((Object)StackHelper.create(this, code, null));
            }
        }
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        if (!((Boolean)Configuration.ACCESS_SETTINGS.allowPublicBuckets.get()).booleanValue() && StackHelper.isPublic(stack)) {
            if (!((Boolean)Configuration.ACCESS_SETTINGS.allowPersonalBuckets.get()).booleanValue()) {
                String teamID = Function.getPlayerTeamID((PlayerEntity)player);
                if (!Strings.isNullOrEmpty((String)teamID)) {
                    StackHelper.setOwner(stack, "#" + teamID);
                }
            } else {
                StackHelper.setOwner(stack, player.func_110124_au().toString());
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean isSneaking = player.func_213453_ef();
        BlockPos pos = null;
        boolean hitTypeBlock = false;
        Direction facing = Direction.func_239631_a_((Random)world.field_73012_v);
        BlockRayTraceResult mop = ItemEnderBucket.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)(!isSneaking ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE));
        if (mop instanceof BlockRayTraceResult && mop.func_216346_c() != RayTraceResult.Type.MISS) {
            hitTypeBlock = true;
            pos = mop.func_216350_a();
            facing = mop.func_216354_b();
        }
        if (!world.field_72995_K) {
            if (pos != null && world.func_180495_p(pos).func_177230_c() == Values.blockEnderTank) {
                TileEntityEnderTank tankTile;
                if (isSneaking && (tankTile = (TileEntityEnderTank)world.func_175625_s(pos)) != null) {
                    if (tankTile.hasError()) {
                        TankInfoHelper.sendLinkError(player, 2);
                    } else {
                        if (tankTile.canLink(player)) {
                            return ActionResult.func_226248_a_((Object)StackHelper.create(this, tankTile.getCode(), tankTile.getOwnerID()));
                        }
                        TankInfoHelper.sendLinkError(player, tankTile.isTeam() ? 3 : 1);
                    }
                }
                return ActionResult.func_226248_a_((Object)stack);
            }
            if (!StackHelper.isPublic(stack) || ((Boolean)Configuration.ACCESS_SETTINGS.allowPublicBuckets.get()).booleanValue()) {
                boolean showInfo = true;
                if (pos != null) {
                    showInfo = isSneaking ? this.placeLiquid(stack, player, hand, world, pos, facing, hitTypeBlock) : this.pickupLiquid(stack, player, hand, world, pos, facing);
                }
                if (showInfo) {
                    String[] network = new String[]{StackHelper.getOwnerID(stack), StackHelper.getCode(stack)};
                    TankInfoHelper.sendTankInfo(player, StackHelper.getOwnerName(stack), network[0], network[1]);
                }
            } else {
                TankInfoHelper.sendError(player, "endertanks.bucket.public.disabled");
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    private boolean pickupLiquid(ItemStack stack, PlayerEntity player, Hand hand, World world, BlockPos pos, Direction facing) {
        if (player.func_175151_a(pos, facing, stack)) {
            FlowingFluid flowingFluid;
            BlockState state;
            int getAmount;
            IFluidHandler bucketTank = TankHelper.getTank(StackHelper.getOwnerID(stack), StackHelper.getCode(stack), world.field_72995_K).getTankFor(IFluidHandler.class);
            if (bucketTank == null) {
                return false;
            }
            IFluidHandler fromHandler = CapabilityHelper.FLUIDS.getHandler((IWorld)world, pos, facing);
            FluidStack bucketLiquid = bucketTank.getFluidInTank(0);
            int n = getAmount = !bucketLiquid.isEmpty() ? Math.min(1000, bucketTank.getTankCapacity(0) - bucketLiquid.getAmount()) : 1000;
            if (fromHandler != null) {
                FluidStack getLiquid = FluidUtil.tryFluidTransfer((IFluidHandler)bucketTank, (IFluidHandler)fromHandler, (int)getAmount, (boolean)true);
                if (!getLiquid.isEmpty()) {
                    world.func_184133_a(player, pos, getLiquid.getFluid().getAttributes().getFillSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (player.field_71075_bZ.field_75098_d) {
                        bucketTank.drain(getLiquid, IFluidHandler.FluidAction.EXECUTE);
                    }
                    return true;
                }
            } else if (CauldronHelper.isCauldron((IBlockReader)world, pos)) {
                if (CauldronHelper.drainCauldron(bucketTank, world, pos, !player.field_71075_bZ.field_75098_d)) {
                    world.func_184133_a(player, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return true;
                }
            } else if (getAmount >= 1000 && (state = world.func_180495_p(pos)).func_177230_c() instanceof FlowingFluidBlock && (Integer)state.func_177229_b((Property)FlowingFluidBlock.field_176367_b) == 0 && (flowingFluid = ((FlowingFluidBlock)state.func_177230_c()).getFluid()) != null) {
                Fluid fluid = flowingFluid.getFluid();
                if (bucketLiquid.isEmpty() || bucketLiquid.getFluid().equals(fluid)) {
                    ((FlowingFluidBlock)state.func_177230_c()).func_204508_a((IWorld)world, pos, state);
                    world.func_184133_a(player, pos, fluid.getAttributes().getFillSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    if (!player.field_71075_bZ.field_75098_d) {
                        bucketTank.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean placeLiquid(ItemStack stack, PlayerEntity player, Hand hand, World world, BlockPos pos, Direction facing, boolean hitTypeBlock) {
        FluidStack placeLiquid;
        BlockPos sPos;
        IFluidHandler bucketTank = TankHelper.getTank(StackHelper.getOwnerID(stack), StackHelper.getCode(stack), world.field_72995_K).getTankFor(IFluidHandler.class);
        if (bucketTank == null) {
            return false;
        }
        FluidStack bucketLiquid = bucketTank.getFluidInTank(0);
        int putAmount = !bucketLiquid.isEmpty() ? Math.min(1000, bucketLiquid.getAmount()) : 0;
        IFluidHandler toHandler = CapabilityHelper.FLUIDS.getHandler((IWorld)world, pos, facing);
        if (toHandler != null) {
            FluidStack putLiquid;
            if (player.func_175151_a(pos, facing, stack) && !(putLiquid = FluidUtil.tryFluidTransfer((IFluidHandler)toHandler, (IFluidHandler)bucketTank, (int)putAmount, (boolean)true)).isEmpty()) {
                world.func_184133_a(player, pos, putLiquid.getFluid().getAttributes().getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (player.field_71075_bZ.field_75098_d) {
                    bucketTank.fill(putLiquid, IFluidHandler.FluidAction.EXECUTE);
                }
                return true;
            }
        } else if (CauldronHelper.isCauldron((IBlockReader)world, pos)) {
            if (player.func_175151_a(pos, facing, stack) && CauldronHelper.fillCauldron(bucketTank, world, pos, !player.field_71075_bZ.field_75098_d)) {
                world.func_184133_a(player, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return true;
            }
        } else if (putAmount >= 1000 && hitTypeBlock && player.func_175151_a(sPos = pos.func_177972_a(facing), facing, stack) && FluidUtil.tryPlaceFluid((PlayerEntity)player, (World)world, (Hand)hand, (BlockPos)sPos, (ItemStack)stack, (FluidStack)(placeLiquid = bucketTank.drain(1000, IFluidHandler.FluidAction.SIMULATE))).isSuccess()) {
            world.func_190524_a(sPos, Blocks.field_150350_a, sPos);
            if (player.field_71075_bZ.field_75098_d) {
                bucketTank.fill(placeLiquid, IFluidHandler.FluidAction.EXECUTE);
            }
            return true;
        }
        return false;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return stack.func_190926_b() ? null : new EnderFluidHandlerItemStack(stack);
    }

    public String func_77667_c(ItemStack stack) {
        return "item.endertanks.bucket." + (StackHelper.isPublic(stack) ? "public" : (StackHelper.isTeam(stack) ? "team" : "private"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advancedTooltips) {
        tooltip.add((ITextComponent)new StringTextComponent(" " + Localization.get((String)"info.endertanks.tank.code.txt") + " " + StackHelper.getCode(stack)));
        String owner = TankInfoHelper.formatTankOwner(StackHelper.getOwnerName(stack));
        if (!Strings.isNullOrEmpty((String)owner)) {
            tooltip.add((ITextComponent)new StringTextComponent(owner));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index > 0 && index < 4 && !data.stack.func_190926_b()) {
            int value = MathHelper.func_76125_a((int)Integer.parseInt("" + StackHelper.getCode(data.stack).charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }
}

