/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.inventory;

import com.google.common.base.Strings;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.StackHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class ContainerProviders {

    public static class EnderBag
    implements INamedContainerProvider {
        private final ITextComponent displayName;
        private final ItemStack stack;

        public EnderBag(ItemStack stack, String owner, String code) {
            this.stack = stack;
            this.displayName = new StringTextComponent(!Strings.isNullOrEmpty((String)owner) ? owner.toLowerCase() : "all." + code.toLowerCase());
        }

        public ITextComponent func_145748_c_() {
            return this.displayName;
        }

        @Nullable
        public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
            return new ContainerEnderChest(id, playerInv, ChestHelper.getChest(player.func_130014_f_(), StackHelper.getOwnerID(this.stack), StackHelper.getCode(this.stack)), StackHelper.getOwnerName(this.stack));
        }
    }

    public static class EnderChest
    implements INamedContainerProvider {
        private final ITextComponent displayName;
        private final TileEntityEnderChest tile;

        public EnderChest(TileEntityEnderChest tile) {
            this.tile = tile;
            this.displayName = new StringTextComponent(tile.getOwner().toLowerCase() + "." + tile.getCode().toLowerCase());
        }

        public ITextComponent func_145748_c_() {
            return this.displayName;
        }

        @Nullable
        public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
            return new ContainerEnderChest(id, playerInv, this.tile);
        }
    }
}

