/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.block;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;
import shetiphian.core.common.CapabilityHelper;
import shetiphian.core.common.DyeHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.Materials;
import shetiphian.enderchests.Configuration;
import shetiphian.enderchests.EnderChests;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.common.block.HitBoxHelper;
import shetiphian.enderchests.common.inventory.ContainerProviders;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.misc.StackHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class BlockEnderChest
extends Block
implements IColored {
    public static final BooleanProperty STATIC = BooleanProperty.func_177716_a((String)"static");
    public static final DirectionProperty FACING = DirectionProperty.func_196962_a((String)"facing", (Direction[])Direction.values());
    private static final EnumProperty<EnumType> VARIANT = EnumProperty.func_177709_a((String)"variant", EnumType.class);
    public static final HashMap<Direction, VoxelShape[]> SHAPES = new HashMap();
    public static final HashMap<Direction, VoxelShape[]> SHAPES2 = new HashMap();

    public BlockEnderChest() {
        super(AbstractBlock.Properties.func_200949_a((Material)Materials.IMMOVABLE_TRANSLUCENT, (MaterialColor)MaterialColor.field_151646_E).func_200948_a(1.5f, 5.0f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).harvestLevel(0).func_235842_b_((state, world, pos) -> false));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)STATIC, (Comparable)Boolean.valueOf(true)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, VARIANT, STATIC});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityEnderChest();
    }

    private TileEntityEnderChest getTile(IBlockReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityEnderChest ? (TileEntityEnderChest)tile : null;
    }

    public boolean canCreatureSpawn(BlockState state, IBlockReader world, BlockPos pos, EntitySpawnPlacementRegistry.PlacementType type, @Nullable EntityType<?> entityType) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (SHAPES.isEmpty()) {
            Map<Direction, VoxelShape> chest_body = HitBoxHelper.getBody();
            Map<Direction, VoxelShape> chest_lid = HitBoxHelper.getLid();
            Map<Direction, VoxelShape> top_ring = HitBoxHelper.getRing_Top();
            Map<Direction, VoxelShape> middle_ring = HitBoxHelper.getRing_Middle();
            Map<Direction, VoxelShape> bottom_ring = HitBoxHelper.getRing_Bottom();
            for (Direction direction : Direction.values()) {
                VoxelShape[] shapes = new VoxelShape[]{chest_body.getOrDefault(direction, VoxelShapes.func_197880_a()), top_ring.getOrDefault(direction, VoxelShapes.func_197880_a()), middle_ring.getOrDefault(direction, VoxelShapes.func_197880_a()), bottom_ring.getOrDefault(direction, VoxelShapes.func_197880_a()), chest_lid.getOrDefault(direction, VoxelShapes.func_197880_a())};
                SHAPES.put(direction, shapes);
            }
        }
        if (!SHAPES.isEmpty()) {
            Direction direction = BlockEnderChest.getFacing(state);
            TileEntityEnderChest tile = this.getTile(world, pos);
            if (tile != null) {
                if (!SHAPES2.containsKey(direction)) {
                    VoxelShape base = SHAPES.get(direction)[0];
                    VoxelShape lid = SHAPES.get(direction)[4];
                    Vector3i vec = direction.func_176734_d().func_176730_m();
                    VoxelShape[] shapes = new VoxelShape[11];
                    shapes[0] = VoxelShapes.func_197872_a((VoxelShape)base, (VoxelShape)lid);
                    for (int index = 1; index <= 10; ++index) {
                        double var = (double)index / 10.0 * (double)0.7f;
                        shapes[index] = VoxelShapes.func_197872_a((VoxelShape)base, (VoxelShape)lid.func_197751_a((double)vec.func_177958_n() * var, (double)vec.func_177956_o() * var, (double)vec.func_177952_p() * var));
                    }
                    SHAPES2.put(direction, shapes);
                }
                return SHAPES2.get(direction)[tile.getLidOffsetIndex()];
            }
            return SHAPES.get(direction)[0];
        }
        return VoxelShapes.func_197868_b();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return this.onBlockActivated(state, world, pos, player, player.func_184586_b(hand));
    }

    public ActionResultType onBlockActivated(BlockState state, World world, BlockPos pos, PlayerEntity player, ItemStack heldItem) {
        TileEntityEnderChest chestTile = this.getTile((IBlockReader)world, pos);
        if (chestTile == null) {
            return ActionResultType.PASS;
        }
        if (!player.func_213453_ef()) {
            if (!(world.field_72995_K || !heldItem.func_190926_b() && heldItem.func_77973_b().getToolTypes(heldItem).contains(Values.WRENCH))) {
                BlockPos blockpos = pos.func_177972_a(BlockEnderChest.getFacing(state).func_176734_d());
                if (player instanceof ServerPlayerEntity && chestTile.canUse(player) && !world.func_180495_p(blockpos).func_215686_e((IBlockReader)world, blockpos)) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerProviders.EnderChest(chestTile), (BlockPos)pos);
                }
            }
            return ActionResultType.SUCCESS;
        }
        if (!heldItem.func_190926_b()) {
            DyeColor color;
            int subHit;
            if (chestTile.isPublic()) {
                boolean changed = false;
                if (Values.listPersonal.contains(heldItem.func_77973_b())) {
                    if (((Boolean)Configuration.ACCESS_SETTINGS.allowPersonalChests.get()).booleanValue()) {
                        changed = true;
                        if (!world.field_72995_K) {
                            chestTile.setOwner(player, heldItem.func_77946_l().func_77979_a(1));
                            Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.PRIVATE))), (boolean)true);
                        }
                    } else if (!world.field_72995_K) {
                        ChestInfoHelper.sendError(player, "enderchests.chest.private.disabled");
                    }
                }
                if (!changed && Values.listTeam.contains(heldItem.func_77973_b())) {
                    if (((Boolean)Configuration.ACCESS_SETTINGS.allowTeamChests.get()).booleanValue()) {
                        String teamID = Function.getPlayerTeamID((PlayerEntity)player);
                        if (!Strings.isNullOrEmpty((String)teamID)) {
                            changed = true;
                            if (!world.field_72995_K) {
                                chestTile.setOwner(Function.getTeamDisplayName((String)teamID), "#" + teamID, heldItem.func_77946_l().func_77979_a(1));
                                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)EnumType.TEAM))), (boolean)true);
                            }
                        } else if (!world.field_72995_K) {
                            ChestInfoHelper.sendError(player, "shetiphian.team.noteam");
                        }
                    } else if (!world.field_72995_K) {
                        ChestInfoHelper.sendError(player, "enderchests.chest.team.disabled");
                    }
                }
                if (changed) {
                    if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                        heldItem.func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
            if (!chestTile.canEdit(player)) {
                return ActionResultType.SUCCESS;
            }
            short capacity = ChestHelper.getCapacity(world, chestTile.getOwnerID(), chestTile.getCode());
            if (capacity < (Integer)Configuration.UPGRADE_SETTINGS.chestSizeMax.get()) {
                int newValue = 0;
                if (Values.listSmallCap_Single.contains(heldItem.func_77973_b())) {
                    newValue = -1;
                    if (chestTile.applyItem(heldItem)) {
                        newValue = 3;
                    } else if (!world.field_72995_K) {
                        ChestInfoHelper.sendError(player, "enderchests.chest.upgrade_used");
                    }
                }
                if (newValue == 0 && Values.listSmallCap_Multi.contains(heldItem.func_77973_b())) {
                    newValue = 3;
                }
                if (newValue == 0 && capacity + 9 <= (Integer)Configuration.UPGRADE_SETTINGS.chestSizeMax.get()) {
                    if (Values.listLargeCap_Single.contains(heldItem.func_77973_b())) {
                        newValue = -1;
                        if (chestTile.applyItem(heldItem)) {
                            newValue = 9;
                        } else if (!world.field_72995_K) {
                            ChestInfoHelper.sendError(player, "enderchests.chest.upgrade_used");
                        }
                    }
                    if (newValue == 0 && Values.listLargeCap_Multi.contains(heldItem.func_77973_b())) {
                        newValue = 9;
                    }
                }
                if (newValue > 0) {
                    if (!world.field_72995_K) {
                        ChestHelper.setCapacity(world, chestTile.getOwnerID(), chestTile.getCode(), (byte)(capacity + newValue));
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldItem.func_190918_g(1);
                        }
                        ChestInfoHelper.sendCapacityInfo(player, chestTile);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
            if (((Boolean)Configuration.GENERAL.enableInWorldRecoloring.get()).booleanValue() && (subHit = Function.getSubShapeHit((Entity)player, (BlockPos)pos, (VoxelShape[])SHAPES.get(state.func_177229_b((Property)FACING)))) > 0 && subHit < 4 && (color = DyeHelper.getDyeColor((Item)heldItem.func_77973_b())) != null && chestTile.doColorRing(color, player)) {
                if (!world.field_72995_K) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldItem.func_190918_g(1);
                    }
                    world.func_195593_d(pos, (Block)this);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        TileEntityEnderChest tile = this.getTile(world, pos);
        if (tile != null && tile.canEdit(player)) {
            return super.func_180647_a(state, player, world, pos);
        }
        return -1.0f;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityEnderChest tile = this.getTile((IBlockReader)world, pos);
        if (tile != null) {
            String code = StackHelper.getCode(stack);
            while (code.length() < 3) {
                code = "0" + code;
            }
            ItemStack personalItem = StackHelper.getPersonalItem(stack);
            tile.setCode(code);
            if (!personalItem.func_190926_b()) {
                tile.setOwner(StackHelper.getOwnerName(stack), StackHelper.getOwnerID(stack), personalItem);
                Function.setBlock((IWorld)world, (BlockPos)pos, (BlockState)((BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)(tile.isTeam() ? EnumType.TEAM : EnumType.PRIVATE)))), (boolean)true);
            }
        }
    }

    public boolean canHarvestBlock(BlockState state, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.func_180647_a(state, player, world, pos) > -1.0f;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (this.func_180647_a(state, player, (IBlockReader)world, pos) < 0.0f) {
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List drops = super.func_220076_a(state, builder);
        TileEntity builderTile = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (builderTile instanceof TileEntityEnderChest) {
            ItemStack personal;
            TileEntityEnderChest tile = (TileEntityEnderChest)builderTile;
            Entity builderEntity = (Entity)builder.func_216019_b(LootParameters.field_216281_a);
            if (builderEntity != null && builderEntity.func_213453_ef() && (personal = tile.getPersonalItem()) != null) {
                drops.add(personal);
            }
        }
        return drops;
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        TileEntityEnderChest tile = this.getTile(world, pos);
        if (tile != null) {
            return StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
        }
        return new ItemStack((IItemProvider)this);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntityEnderChest tile = this.getTile(world, pos);
        if (tile != null) {
            if (player != null && !player.func_213453_ef()) {
                if (tile.isTeam() && (player.field_71075_bZ.field_75098_d || tile.getOwnerID().equalsIgnoreCase("#" + Function.getPlayerTeamID((PlayerEntity)player)))) {
                    return StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
                }
                if (!tile.isPublic() && (player.field_71075_bZ.field_75098_d || tile.getOwnerID().equalsIgnoreCase(player.func_110124_au().toString()))) {
                    return StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
                }
            }
            return StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), null);
        }
        return new ItemStack((IItemProvider)this);
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        if (rotation != Rotation.NONE) {
            Direction facing = BlockEnderChest.getFacing(state);
            if (rotation == Rotation.CLOCKWISE_180) {
                return (BlockState)state.func_206870_a((Property)FACING, (Comparable)facing.func_176734_d());
            }
            int value = facing.ordinal() + (rotation == Rotation.CLOCKWISE_90 ? 1 : -1);
            value = value < 0 ? 5 : (value > 5 ? 0 : value);
            return (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.func_82600_a((int)value));
        }
        return state;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        return CapabilityHelper.COMPARATOR.getInputOverride((IWorld)world, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        TileEntityEnderChest tile;
        if (index > 0 && index < 4 && data.world != null && data.pos != null && (tile = this.getTile((IBlockReader)data.world, data.pos)) != null) {
            int value = MathHelper.func_76125_a((int)Integer.parseInt("" + tile.getCode().charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }

    public static Direction getFacing(BlockState state) {
        Direction facing;
        try {
            facing = (Direction)state.func_177229_b((Property)FACING);
        }
        catch (Exception e) {
            facing = Direction.DOWN;
            EnderChests.LOGGER.error("PropertyEnum 'BlockEnderChest.FACING' not found in provided BlockState, returning 'DOWN'. Provided BlockState: " + state);
        }
        return facing;
    }

    public static enum EnumType implements IStringSerializable
    {
        PUBLIC("public"),
        PRIVATE("private"),
        TEAM("team");

        private final String name;

        private EnumType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

