/*
 * Decompiled with CFR 0.152.
 */
package fuzs.enchantinginfuser.world.level.block.entity;

import fuzs.enchantinginfuser.registry.ModRegistry;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.BookItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.EnchantingTableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.LockCode;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class InfuserBlockEntity
extends EnchantingTableTileEntity
implements ISidedInventory {
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    private LockCode code = LockCode.field_180162_a;

    public TileEntityType<?> func_200662_C() {
        return ModRegistry.INFUSER_BLOCK_ENTITY_TYPE;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inventory.clear();
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
        this.code = LockCode.func_180158_b((CompoundNBT)nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.saveMetadataAndItems(compound);
        this.code.func_180157_a(compound);
        return compound;
    }

    private CompoundNBT saveMetadataAndItems(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191281_a((CompoundNBT)compound, this.inventory, (boolean)true);
        return compound;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.saveMetadataAndItems(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT tag = pkt.func_148857_g();
        this.inventory.clear();
        ItemStackHelper.func_191283_b((CompoundNBT)tag, this.inventory);
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return index >= 0 && index < this.inventory.size() ? (ItemStack)this.inventory.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index >= 0 && index < this.inventory.size()) {
            this.inventory.set(index, (Object)stack);
        }
        this.func_70296_d();
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b != null && this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > 64.0);
    }

    public void func_174888_l() {
        this.inventory.clear();
        this.func_70296_d();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return ((ItemStack)this.inventory.get(0)).func_190926_b() && (stack.func_77956_u() || stack.func_77973_b() instanceof BookItem);
        }
        return false;
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 0 && (stack.func_77948_v() || stack.func_77973_b() instanceof EnchantedBookItem);
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    public boolean canOpen(PlayerEntity p_213904_1_) {
        return LockableTileEntity.func_213905_a((PlayerEntity)p_213904_1_, (LockCode)this.code, (ITextComponent)this.func_145748_c_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }
}

