/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakIdentityHashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_SIZE = 16;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final ReferenceQueue<K> referenceQueue;
    private int elementCount;
    private Entry<K, V>[] elementData;
    private final int loadFactor;
    private int threshold;
    private volatile int modCount;
    private Set<K> keySet;
    private Collection<V> valuesCollection;

    private static <K, V> Entry<K, V>[] newEntryArray(int size) {
        return new Entry[size];
    }

    public WeakIdentityHashMap() {
        this(16);
    }

    public WeakIdentityHashMap(int capacity) {
        this(capacity, 0.75f);
    }

    public WeakIdentityHashMap(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity < 0: " + capacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor <= 0: " + loadFactor);
        }
        this.elementCount = 0;
        this.elementData = WeakIdentityHashMap.newEntryArray(capacity == 0 ? 1 : capacity);
        this.loadFactor = (int)(loadFactor * 10000.0f);
        this.computeMaxSize();
        this.referenceQueue = new ReferenceQueue();
    }

    public WeakIdentityHashMap(Map<? extends K, ? extends V> map) {
        this(map.size() * 2);
        this.putAll(map);
    }

    @Override
    public void clear() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
            Arrays.fill(this.elementData, null);
            ++this.modCount;
            while (this.referenceQueue.poll() != null) {
            }
        }
    }

    private void computeMaxSize() {
        this.threshold = (int)((long)this.elementData.length * (long)this.loadFactor / 10000L);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.poll();
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return WeakIdentityHashMap.this.size();
            }

            @Override
            public void clear() {
                WeakIdentityHashMap.this.clear();
            }

            @Override
            public boolean remove(Object object) {
                if (this.contains(object)) {
                    WeakIdentityHashMap.this.remove(((Map.Entry)object).getKey());
                    return true;
                }
                return false;
            }

            @Override
            public boolean contains(Object object) {
                Object key;
                Entry entry;
                if (object instanceof Map.Entry && (entry = WeakIdentityHashMap.this.getEntry(((Map.Entry)object).getKey())) != null && ((key = entry.get()) != null || entry.isNull)) {
                    return object.equals(entry);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new HashIterator(new Entry.Type<Map.Entry<K, V>, K, V>(){

                    @Override
                    public Map.Entry<K, V> get(Map.Entry<K, V> entry) {
                        return entry;
                    }
                });
            }
        };
    }

    @Override
    public Set<K> keySet() {
        this.poll();
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return WeakIdentityHashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return WeakIdentityHashMap.this.size();
                }

                @Override
                public void clear() {
                    WeakIdentityHashMap.this.clear();
                }

                @Override
                public boolean remove(Object key) {
                    if (WeakIdentityHashMap.this.containsKey(key)) {
                        WeakIdentityHashMap.this.remove(key);
                        return true;
                    }
                    return false;
                }

                @Override
                public Iterator<K> iterator() {
                    return new HashIterator(new Entry.Type<K, K, V>(){

                        @Override
                        public K get(Map.Entry<K, V> entry) {
                            return entry.getKey();
                        }
                    });
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        this.poll();
        if (this.valuesCollection == null) {
            this.valuesCollection = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return WeakIdentityHashMap.this.size();
                }

                @Override
                public void clear() {
                    WeakIdentityHashMap.this.clear();
                }

                @Override
                public boolean contains(Object object) {
                    return WeakIdentityHashMap.this.containsValue(object);
                }

                @Override
                public Iterator<V> iterator() {
                    return new HashIterator(new Entry.Type<V, K, V>(){

                        @Override
                        public V get(Map.Entry<K, V> entry) {
                            return entry.getValue();
                        }
                    });
                }
            };
        }
        return this.valuesCollection;
    }

    @Override
    public V get(Object key) {
        Entry<K, V> entry = this.getEntry(key);
        return entry != null ? (V)entry.value : null;
    }

    private Entry<K, V> getEntry(Object key) {
        this.poll();
        if (key != null) {
            int index = (System.identityHashCode(key) & Integer.MAX_VALUE) % this.elementData.length;
            Entry<K, V> entry = this.elementData[index];
            while (entry != null) {
                if (key == entry.get()) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }
        Entry<K, V> entry = this.elementData[0];
        while (entry != null) {
            if (entry.isNull) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean containsValue(Object value) {
        this.poll();
        if (value != null) {
            int i = this.elementData.length;
            while (--i >= 0) {
                Entry<K, V> entry = this.elementData[i];
                while (entry != null) {
                    Object key = entry.get();
                    if ((key != null || entry.isNull) && value.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        } else {
            int i = this.elementData.length;
            while (--i >= 0) {
                Entry<K, V> entry = this.elementData[i];
                while (entry != null) {
                    Object key = entry.get();
                    if ((key != null || entry.isNull) && entry.value == null) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private void poll() {
        Entry toRemove;
        while ((toRemove = (Entry)this.referenceQueue.poll()) != null) {
            this.removeEntry(toRemove);
        }
    }

    private void removeEntry(Entry<K, V> toRemove) {
        Entry<K, V> last = null;
        int index = (toRemove.hash & Integer.MAX_VALUE) % this.elementData.length;
        Entry<K, V> entry = this.elementData[index];
        while (entry != null) {
            if (toRemove == entry) {
                ++this.modCount;
                if (last == null) {
                    this.elementData[index] = entry.next;
                } else {
                    last.next = entry.next;
                }
                --this.elementCount;
                break;
            }
            last = entry;
            entry = entry.next;
        }
    }

    @Override
    public V put(K key, V value) {
        Entry<K, V> entry;
        this.poll();
        int index = 0;
        if (key != null) {
            index = (System.identityHashCode(key) & Integer.MAX_VALUE) % this.elementData.length;
            entry = this.elementData[index];
            while (entry != null && key != entry.get()) {
                entry = entry.next;
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && !entry.isNull) {
                entry = entry.next;
            }
        }
        if (entry == null) {
            ++this.modCount;
            if (++this.elementCount > this.threshold) {
                this.rehash();
                index = key == null ? 0 : (System.identityHashCode(key) & Integer.MAX_VALUE) % this.elementData.length;
            }
            entry = new Entry<K, V>(key, value, this.referenceQueue);
            entry.next = this.elementData[index];
            this.elementData[index] = entry;
            return null;
        }
        Object result = entry.value;
        entry.value = value;
        return result;
    }

    private void rehash() {
        assert (this.elementData.length > 0);
        int length = this.elementData.length * 2;
        Entry<K, V>[] newData = WeakIdentityHashMap.newEntryArray(length);
        for (Entry<K, V> entry : this.elementData) {
            while (entry != null) {
                int index = entry.isNull ? 0 : (entry.hash & Integer.MAX_VALUE) % length;
                Entry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
        }
        this.elementData = newData;
        this.computeMaxSize();
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> entry;
        this.poll();
        int index = 0;
        Entry<K, V> last = null;
        if (key != null) {
            index = (System.identityHashCode(key) & Integer.MAX_VALUE) % this.elementData.length;
            entry = this.elementData[index];
            while (entry != null && key != entry.get()) {
                last = entry;
                entry = entry.next;
            }
        } else {
            entry = this.elementData[0];
            while (entry != null && !entry.isNull) {
                last = entry;
                entry = entry.next;
            }
        }
        if (entry != null) {
            ++this.modCount;
            if (last == null) {
                this.elementData[index] = entry.next;
            } else {
                last.next = entry.next;
            }
            --this.elementCount;
            return entry.value;
        }
        return null;
    }

    @Override
    public int size() {
        this.poll();
        return this.elementCount;
    }

    private static final class Entry<K, V>
    extends WeakReference<K>
    implements Map.Entry<K, V> {
        final int hash;
        boolean isNull;
        V value;
        Entry<K, V> next;

        Entry(K key, V object, ReferenceQueue<K> queue) {
            super(key, queue);
            this.isNull = key == null;
            this.hash = this.isNull ? 0 : System.identityHashCode(key);
            this.value = object;
        }

        @Override
        public K getKey() {
            return (K)super.get();
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V object) {
            V result = this.value;
            this.value = object;
            return result;
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)other;
            Object key = super.get();
            return key == entry.getKey() && (this.value == null ? this.value == entry.getValue() : this.value.equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash + (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return String.valueOf(super.get()) + "=" + String.valueOf(this.value);
        }

        static interface Type<R, K, V> {
            public R get(Map.Entry<K, V> var1);
        }
    }

    private class HashIterator<R>
    implements Iterator<R> {
        private int position = 0;
        private int expectedModCount;
        private Entry<K, V> currentEntry;
        private Entry<K, V> nextEntry;
        private K nextKey;
        private final Entry.Type<R, K, V> type;

        HashIterator(Entry.Type<R, K, V> type) {
            this.type = type;
            this.expectedModCount = WeakIdentityHashMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry != null && (this.nextKey != null || this.nextEntry.isNull)) {
                return true;
            }
            while (true) {
                if (this.nextEntry == null) {
                    while (this.position < WeakIdentityHashMap.this.elementData.length && (this.nextEntry = WeakIdentityHashMap.this.elementData[this.position++]) == null) {
                    }
                    if (this.nextEntry == null) {
                        return false;
                    }
                }
                this.nextKey = this.nextEntry.get();
                if (this.nextKey != null || this.nextEntry.isNull) {
                    return true;
                }
                this.nextEntry = this.nextEntry.next;
            }
        }

        @Override
        public R next() {
            if (this.expectedModCount == WeakIdentityHashMap.this.modCount) {
                if (this.hasNext()) {
                    this.currentEntry = this.nextEntry;
                    this.nextEntry = this.currentEntry.next;
                    R result = this.type.get(this.currentEntry);
                    this.nextKey = null;
                    return result;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void remove() {
            if (this.expectedModCount != WeakIdentityHashMap.this.modCount) throw new ConcurrentModificationException();
            if (this.currentEntry == null) throw new IllegalStateException();
            WeakIdentityHashMap.this.removeEntry(this.currentEntry);
            this.currentEntry = null;
            ++this.expectedModCount;
        }
    }
}

