/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg.util;

import io.github.aratakileo.elegantia.math.Vector2iInterface;
import io.github.aratakileo.elegantia.util.Strings;
import io.github.aratakileo.emogg.emoji.EmojiGlyph;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public final class EmojiUtil {
    public static final String PNG_EXTENSION = ".png";
    public static final String EMOJI_FOLDER_NAME = "emoji";

    public static void render(@NotNull EmojiGlyph emojiGlyph, @NotNull class_332 guiGraphics, int x, int y, int size, int color, boolean grayscale) {
        class_1921 renderType = emojiGlyph.method_24045(class_327.class_6415.field_33993);
        if (grayscale && emojiGlyph instanceof EmojiGlyph.TexturedEmojiGlyph) {
            EmojiGlyph.TexturedEmojiGlyph textured = (EmojiGlyph.TexturedEmojiGlyph)emojiGlyph;
            renderType = textured.grayScaleRenderType(class_327.class_6415.field_33993);
        }
        class_4588 builder = guiGraphics.method_51450().getBuffer(renderType);
        float scale = (float)size / Math.max(emojiGlyph.getAdvance(), 8.0f);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)x, (float)y, 0.0f);
        guiGraphics.method_51448().method_22905(scale, scale, 0.0f);
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        emojiGlyph.renderColored(false, 0.0f, 0.0f, guiGraphics.method_51448().method_23760().method_23761(), builder, r, g, b, a, 0xF000F0);
        guiGraphics.method_51448().method_22909();
    }

    public static void render(@NotNull EmojiGlyph emojiGlyph, @NotNull class_332 guiGraphics, @NotNull Vector2iInterface pos, int size, boolean grayscale) {
        EmojiUtil.render(emojiGlyph, guiGraphics, pos.x(), pos.y(), size, grayscale);
    }

    public static void render(@NotNull EmojiGlyph emojiGlyph, @NotNull class_332 guiGraphics, int x, int y, int size, boolean grayscale) {
        EmojiUtil.render(emojiGlyph, guiGraphics, x, y, size, -1, grayscale);
    }

    @NotNull
    public static String normalizeEmojiObjectKey(@NotNull String sourceValue) {
        return StringUtils.strip((String)Strings.camelToSnake((String)sourceValue).replaceAll("-+| +|\\.+", "_").replaceAll("[^a-z0-9_]", ""), (String)"_");
    }

    @NotNull
    public static String getNameFromPath(@NotNull class_2960 resourceLocation) {
        return EmojiUtil.getNameFromPath(resourceLocation.toString());
    }

    @NotNull
    public static String getNameFromPath(@NotNull String path) {
        return path.transform(name -> name.substring(name.lastIndexOf(47) + 1)).transform(name -> name.substring(0, name.lastIndexOf(46)));
    }
}

