/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg.mixin.mixins.gui;

import io.github.aratakileo.elegantia.gui.WidgetBoundsBuilder;
import io.github.aratakileo.elegantia.util.Mouse;
import io.github.aratakileo.emogg.emoji.Emoji;
import io.github.aratakileo.emogg.emoji.EmojiManager;
import io.github.aratakileo.emogg.emoji.FueController;
import io.github.aratakileo.emogg.gui.widget.EmojiButton;
import io.github.aratakileo.emogg.gui.widget.EmojiSelectionMenu;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_408;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import oshi.util.tuples.Pair;

@Mixin(value={class_408.class})
public class ChatScreenMixin {
    @Unique
    public EmojiButton emojiButton;
    @Unique
    public EmojiSelectionMenu emojiSelectionMenu;
    @Unique
    protected Pair<Integer, Boolean> emojiSelectionMenuState;
    @Unique
    protected Emoji emojiButtonDisplayableEmojiState;
    @Shadow
    protected class_342 field_2382;

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void init(CallbackInfo ci) {
        class_408 self = (class_408)this;
        this.field_2382.method_1856(true);
        int emojiButtonSize = this.field_2382.method_25364() - 4;
        this.emojiButton = new EmojiButton(new WidgetBoundsBuilder(emojiButtonSize, emojiButtonSize).setGravity(3).setMargin(4).build());
        this.emojiSelectionMenu = new EmojiSelectionMenu((float)((double)this.emojiButton.getHeight() * 1.5));
        this.emojiSelectionMenu.setRightBottom(self.field_22789 - 2, self.field_22790 - this.field_2382.method_25364() - 3);
        this.emojiSelectionMenu.setOnEmojiSelected(emoji -> this.field_2382.method_1867(emoji.getCode()));
        this.emojiButton.setOnClickListener((btn, byUser) -> {
            if (!this.emojiSelectionMenu.isVisible) {
                this.emojiSelectionMenu.refreshFrequentlyUsedEmojis();
            }
            this.emojiSelectionMenu.isVisible = !this.emojiSelectionMenu.isVisible;
            return true;
        });
        if (EmojiManager.getInstance().isEmpty()) {
            this.emojiButton.isEnabled = false;
            this.emojiButton.isVisible = false;
        }
        self.method_37063((class_364)this.emojiButton);
        self.method_37063((class_364)this.emojiSelectionMenu);
    }

    @Inject(method={"resize"}, at={@At(value="HEAD")})
    public void resizeHead(class_310 minecraft, int x, int y, CallbackInfo ci) {
        this.emojiSelectionMenuState = new Pair((Object)this.emojiSelectionMenu.verticalScrollbar.getProgress(), (Object)this.emojiSelectionMenu.isVisible);
        this.emojiButtonDisplayableEmojiState = this.emojiButton.getDisplayableEmoji();
    }

    @Inject(method={"resize"}, at={@At(value="TAIL")})
    public void resizeTail(class_310 minecraft, int x, int y, CallbackInfo ci) {
        this.emojiSelectionMenu.refreshFrequentlyUsedEmojis();
        this.emojiSelectionMenu.verticalScrollbar.setProgress(((Integer)this.emojiSelectionMenuState.getA()).intValue());
        this.emojiSelectionMenu.isVisible = (Boolean)this.emojiSelectionMenuState.getB();
        this.emojiButton.setDisplayableEmoji(this.emojiButtonDisplayableEmojiState);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void render(class_332 guiGraphics, int mouseX, int mouseY, float dt, CallbackInfo ci) {
        class_408 self = (class_408)this;
        if (this.emojiSelectionMenu.method_25405(mouseX, mouseY)) {
            self.method_25395((class_364)this.emojiSelectionMenu);
            return;
        }
        if (this.emojiButton.method_25405(mouseX, mouseY)) {
            self.method_25395((class_364)this.emojiButton);
            return;
        }
        self.method_25395((class_364)this.field_2382);
    }

    @Inject(method={"handleChatInput"}, at={@At(value="HEAD")})
    public void handleChatInput(String text, boolean addToHistory, CallbackInfoReturnable<Boolean> cir) {
        FueController.collectStatisticFrom(text);
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (keyCode != 256) {
            return;
        }
        if (this.emojiSelectionMenu.isVisible || modifiers == 1) {
            cir.setReturnValue((Object)this.emojiButton.onClick(false));
        }
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseClicked(double mouseX, double mouseY, int button, CallbackInfoReturnable<Boolean> cir) {
        if (Mouse.Button.of((int)button).isLeft()) {
            if (this.emojiButton.isHovered()) {
                cir.setReturnValue((Object)this.emojiButton.onClick(true));
                return;
            }
            if (!this.emojiSelectionMenu.isHovered() && this.emojiSelectionMenu.isVisible) {
                cir.setReturnValue((Object)this.emojiButton.onClick(false));
                return;
            }
        }
        if (Mouse.Button.of((int)button).isMiddle()) {
            cir.setReturnValue((Object)this.emojiButton.onClick(false));
        }
    }

    @Inject(method={"mouseScrolled"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseScrolled(double mouseX, double mouseY, double verticalAmount, CallbackInfoReturnable<Boolean> cir) {
        if (!this.emojiSelectionMenu.isHovered()) {
            return;
        }
        cir.setReturnValue((Object)this.emojiSelectionMenu.mouseScrolled(mouseX, mouseY, 0.0, verticalAmount));
    }
}

