/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg.gui.widget;

import io.github.aratakileo.elegantia.graphics.GuiGraphicsUtil;
import io.github.aratakileo.elegantia.graphics.RectDrawer;
import io.github.aratakileo.elegantia.gui.WidgetBoundsBuilder;
import io.github.aratakileo.elegantia.gui.tooltip.HoveredTooltipPositioner;
import io.github.aratakileo.elegantia.gui.widget.CompositeWidget;
import io.github.aratakileo.elegantia.gui.widget.VerticalScrollbar;
import io.github.aratakileo.elegantia.math.Rect2i;
import io.github.aratakileo.elegantia.math.Vector2dInterface;
import io.github.aratakileo.elegantia.math.Vector2dc;
import io.github.aratakileo.elegantia.math.Vector2ic;
import io.github.aratakileo.elegantia.util.AnyOfPair;
import io.github.aratakileo.elegantia.util.Mouse;
import io.github.aratakileo.emogg.EmoggConfig;
import io.github.aratakileo.emogg.emoji.Emoji;
import io.github.aratakileo.emogg.emoji.EmojiCategory;
import io.github.aratakileo.emogg.emoji.FueController;
import io.github.aratakileo.emogg.gui.CategoryContent;
import io.github.aratakileo.emogg.util.EmojiUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EmojiSelectionMenu
extends CompositeWidget {
    private static final String RESOURCE_PACK_MAKER_URL = "https://aratakileo.github.io/emogg-resourcepack-maker/";
    public static final int MAX_NUMBER_OF_EMOJIS_IN_LINE = 9;
    public static final int MAX_NUMBER_OF_LINES_ON_PAGE = 8;
    public static final int SCROLLBAR_WIDTH = 5;
    private static final class_2960 SETTINGS_ICON = new class_2960("emogg", "gui/icon/settings_icon.png");
    private static final class_2960 PLUS_ICON = new class_2960("emogg", "gui/icon/plus_icon.png");
    private final float emojiSize;
    private final float contentWidth;
    private final Rect2i settingsButtonRect;
    private final Rect2i plusButtonRect;
    private final ArrayList<CategoryContent> categoryContents = new ArrayList();
    private final boolean isSinglePage;
    @Nullable
    private Consumer<Emoji> onEmojiSelected = null;
    @Nullable
    private AnyOfPair<Emoji, CategoryContent> hoveredEmojiOrCategoryContent = null;
    @CompositeWidget.CompositePart(lateInitAnchor="verticalScrollbar")
    public final VerticalScrollbar verticalScrollbar;

    protected EmojiSelectionMenu(float emojiSize, int headerHeight, float contentWidth) {
        super(new Rect2i(0, 0, (int)contentWidth + 1 + 5, (int)((emojiSize + 1.0f) * 8.0f) + 1 + headerHeight));
        this.isVisible = false;
        this.emojiSize = emojiSize;
        this.contentWidth = contentWidth;
        int totalLinesAmount = 0;
        for (String categoryKey : EmojiCategory.getCategoryKeys(true)) {
            CategoryContent categoryContent = new CategoryContent(categoryKey);
            if (categoryContent.isEmpty()) continue;
            this.categoryContents.add(categoryContent);
            totalLinesAmount += categoryContent.getRenderLineCount();
        }
        this.isSinglePage = totalLinesAmount < 8;
        this.verticalScrollbar = new VerticalScrollbar(new WidgetBoundsBuilder(5, this.getHeight() - headerHeight - 1).setGravity(3).setParentBounds(this.getBounds()).build(), totalLinesAmount - 8, 2, 1);
        this.declareAsInited("verticalScrollbar");
        if (this.isSinglePage) {
            this.setWidth(this.getWidth() - 5);
        }
        float buttonSize = 10.0f;
        this.settingsButtonRect = new Rect2i((int)((float)this.getWidth() - 8.0f - 3.0f), 1, 10);
        this.plusButtonRect = this.settingsButtonRect.copy().moveX(-11);
        this.setTooltipPositionerGetter(HoveredTooltipPositioner::new);
    }

    public EmojiSelectionMenu(float emojiSize) {
        this(emojiSize, 11, (emojiSize + 1.0f) * 9.0f);
    }

    public void renderWidget(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float dt) {
        this.disableTooltip();
        RectDrawer.with((class_332)guiGraphics, (Rect2i)this.getBounds().setIpHeight((int)this.emojiSize)).draw(-1442840576);
        GuiGraphicsUtil.drawText((class_332)guiGraphics, (String)StringUtils.capitalize((String)"emogg"), (int)(this.getX() + 2), (int)(this.getY() + 2), (int)0xFFFFFF);
        Rect2i settingsButtonRenderRect = this.settingsButtonRect.move(this.getX(), this.getY());
        Rect2i plusButtonRenderRect = this.plusButtonRect.move(this.getX(), this.getY());
        if (!this.verticalScrollbar.isScrolling()) {
            if (settingsButtonRenderRect.method_3318(mouseX, mouseY)) {
                RectDrawer.with((class_332)guiGraphics, (Rect2i)settingsButtonRenderRect).draw(0x77FFFFFF);
                this.setTooltip((class_2561)class_2561.method_43469((String)"elegantia.gui.config.title", (Object[])new Object[]{"emogg"}));
            }
            if (plusButtonRenderRect.method_3318(mouseX, mouseY)) {
                RectDrawer.with((class_332)guiGraphics, (Rect2i)plusButtonRenderRect).draw(0x77FFFFFF);
                this.setTooltip((class_2561)class_2561.method_43471((String)"emogg.tooltip.action.add_emojis"));
            }
        }
        RectDrawer.with((class_332)guiGraphics, (Rect2i)settingsButtonRenderRect.moveBounds(1, 1, -1, -1)).renderTexture(SETTINGS_ICON);
        RectDrawer.with((class_332)guiGraphics, (Rect2i)plusButtonRenderRect.moveBounds(1, 1, -1, -1)).renderTexture(PLUS_ICON);
        RectDrawer.with((class_332)guiGraphics, (Rect2i)this.getBounds().cutIpTop((int)this.emojiSize)).draw(-1440603614).drawStroke(-1442840576, 1);
        int mouseColumn = (int)((float)(mouseX - this.getX()) / (this.emojiSize + 1.0f));
        int mouseLine = (int)((float)(mouseY - this.getY()) / (this.emojiSize + 1.0f)) - 1;
        int categoryTitleOffsetY = (int)((this.emojiSize - 8.0f) / 2.0f);
        class_327 font = class_310.method_1551().field_1772;
        this.hoveredEmojiOrCategoryContent = null;
        int renderLineIndex = 0;
        int iline = 0;
        for (CategoryContent categoryContent : this.categoryContents) {
            if (iline < this.verticalScrollbar.getProgress() && iline + categoryContent.getRenderLineCount() < this.verticalScrollbar.getProgress()) {
                iline += categoryContent.getRenderLineCount();
                continue;
            }
            if (iline >= this.verticalScrollbar.getProgress()) {
                int categoryTitleLocalY = (int)Math.ceil(this.emojiSize + (float)renderLineIndex * (this.emojiSize + 1.0f) + 1.0f) + 1 + categoryTitleOffsetY;
                boolean isHovered = false;
                if (!this.verticalScrollbar.isScrolling() && mouseColumn >= 0 && mouseColumn < 9 && mouseLine == renderLineIndex) {
                    isHovered = true;
                    this.hoveredEmojiOrCategoryContent = AnyOfPair.ofRight((Object)categoryContent);
                    RectDrawer.with((class_332)guiGraphics, (Rect2i)this.getBounds().moveIp(1, categoryTitleLocalY - 2).setIpSize((int)this.contentWidth, (int)this.emojiSize)).draw(0x77FFFFFF);
                    this.setTooltip(categoryContent.getDisplayableName());
                }
                String expandIndicatorText = categoryContent.isExpanded() ? "-" : "+";
                int expandIndicatorLocalX = (int)(this.contentWidth - (float)font.method_1727(expandIndicatorText));
                GuiGraphicsUtil.drawText((class_332)guiGraphics, (String)categoryContent.getDisplayableName(expandIndicatorLocalX - 2), (int)(this.getX() + 2), (int)(this.getY() + categoryTitleLocalY), (int)(isHovered ? 0xE7E7E7 : 7107965));
                GuiGraphicsUtil.drawText((class_332)guiGraphics, (String)expandIndicatorText, (int)(this.getX() + expandIndicatorLocalX), (int)(this.getY() + categoryTitleLocalY), (int)0xFFFFFF);
                if (EmoggConfig.instance.enableDebugMode) {
                    String debugString = String.valueOf(iline);
                    GuiGraphicsUtil.drawText((class_332)guiGraphics, (String)debugString, (int)(this.getX() - font.method_1727(debugString) - 2), (int)(this.getY() + categoryTitleLocalY), (int)0xFFFFFF);
                }
                ++renderLineIndex;
            }
            ++iline;
            if (renderLineIndex > 7) break;
            if (!categoryContent.isExpanded()) continue;
            boolean renderLine = false;
            int icolumn = 0;
            assert (Objects.nonNull(categoryContent.getEmojis()));
            for (Emoji emoji : categoryContent.getEmojis()) {
                boolean bl = renderLine = iline >= this.verticalScrollbar.getProgress();
                if (renderLine) {
                    Vector2ic emojiPos = this.getPosition().add((int)((float)icolumn * (this.emojiSize + 1.0f) + 1.0f), (int)(this.emojiSize + (float)renderLineIndex * (this.emojiSize + 1.0f) + 1.0f));
                    if (!this.verticalScrollbar.isScrolling() && mouseColumn == icolumn && mouseLine == renderLineIndex) {
                        this.hoveredEmojiOrCategoryContent = AnyOfPair.ofLeft((Object)emoji);
                        this.setTooltip(emoji.getEscapedCode());
                        RectDrawer.with((class_332)guiGraphics, (int)emojiPos.x, (int)emojiPos.y, (int)((int)this.emojiSize), (int)((int)this.emojiSize)).draw(0x77FFFFFF);
                    }
                    EmojiUtil.render(emoji.getGlyph(), guiGraphics, emojiPos.x + 1, emojiPos.y + 1, (int)(this.emojiSize - 2.0f), false);
                    if (EmoggConfig.instance.enableDebugMode && icolumn == 0) {
                        String debugString = String.valueOf(iline);
                        GuiGraphicsUtil.drawText((class_332)guiGraphics, (String)debugString, (int)(this.getX() - font.method_1727(debugString) - 2), (int)(emojiPos.y + 2), (int)0xFFFFFF);
                    }
                }
                if (++icolumn <= 8) continue;
                icolumn = 0;
                ++iline;
                if (renderLine) {
                    ++renderLineIndex;
                }
                if (renderLineIndex <= 7) continue;
                break;
            }
            if (categoryContent.getEmojis().size() % 9 != 0) {
                ++iline;
                if (renderLine) {
                    ++renderLineIndex;
                }
            }
            if (renderLineIndex <= 7) continue;
            break;
        }
        this.verticalScrollbar.isVisible = !this.isSinglePage;
        super.renderWidget(guiGraphics, mouseX, mouseY, dt);
    }

    public boolean onClick(boolean byUser) {
        Vector2dc localisedMousePos = Mouse.getPosition().sub((double)this.getX(), (double)this.getY());
        if (this.settingsButtonRect.contains((Vector2dInterface)localisedMousePos)) {
            GuiGraphicsUtil.playClickSound();
            class_310.method_1551().method_1507((class_437)EmoggConfig.instance.getScreen());
            return true;
        }
        if (this.plusButtonRect.contains((Vector2dInterface)localisedMousePos)) {
            GuiGraphicsUtil.playClickSound();
            class_156.method_668().method_670(RESOURCE_PACK_MAKER_URL);
            return true;
        }
        if (Objects.isNull(this.hoveredEmojiOrCategoryContent)) {
            return false;
        }
        AtomicBoolean isClicked = new AtomicBoolean(false);
        this.hoveredEmojiOrCategoryContent.ifIs(Emoji.class, emoji -> {
            if (Objects.isNull(this.onEmojiSelected)) {
                return;
            }
            if (byUser) {
                GuiGraphicsUtil.playClickSound();
            }
            this.onEmojiSelected.accept((Emoji)emoji);
            isClicked.set(true);
        });
        this.hoveredEmojiOrCategoryContent.ifIs(CategoryContent.class, categoryContent -> {
            if (byUser) {
                GuiGraphicsUtil.playClickSound();
            }
            categoryContent.toggleExpand();
            this.verticalScrollbar.increaseMaxProgress((categoryContent.isExpanded() ? 1 : -1) * (categoryContent.getLineCount() - 1));
            isClicked.set(true);
        });
        return isClicked.get();
    }

    public void refreshFrequentlyUsedEmojis() {
        List<Emoji> frequentlyUsedEmojis = FueController.getEmojis();
        this.verticalScrollbar.setProgress(0);
        if (frequentlyUsedEmojis.isEmpty() || this.categoryContents.isEmpty()) {
            return;
        }
        CategoryContent fueCategoryContent = this.categoryContents.get(0);
        if (fueCategoryContent.getName().equals("$frequently_used")) {
            int oldFueCategoryLineCount = fueCategoryContent.getRenderLineCount();
            fueCategoryContent.refreshEmojis();
            this.verticalScrollbar.increaseMaxProgress(fueCategoryContent.getRenderLineCount() - oldFueCategoryLineCount);
        } else {
            fueCategoryContent = new CategoryContent("$frequently_used");
            if (!fueCategoryContent.isEmpty()) {
                this.categoryContents.add(0, fueCategoryContent);
                this.verticalScrollbar.increaseMaxProgress(fueCategoryContent.getRenderLineCount());
            }
        }
    }

    public void setOnEmojiSelected(@Nullable Consumer<Emoji> onEmojiSelected) {
        this.onEmojiSelected = onEmojiSelected;
    }
}

