/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg.gui.widget;

import io.github.aratakileo.elegantia.gui.widget.AbstractButton;
import io.github.aratakileo.elegantia.math.Rect2i;
import io.github.aratakileo.elegantia.math.Vector2i;
import io.github.aratakileo.elegantia.math.Vector2iInterface;
import io.github.aratakileo.emogg.emoji.Emoji;
import io.github.aratakileo.emogg.emoji.EmojiManager;
import io.github.aratakileo.emogg.util.EmojiUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EmojiButton
extends AbstractButton {
    private Emoji displayableEmoji = null;
    private Emoji prevDisplayableEmoji = null;

    public EmojiButton(@NotNull Rect2i rect2i) {
        super(rect2i, null);
        this.changeDisplayableEmoji();
    }

    @Nullable
    public Emoji getDisplayableEmoji() {
        return this.displayableEmoji;
    }

    public void setDisplayableEmoji(@NotNull Emoji displayableEmoji) {
        this.prevDisplayableEmoji = this.displayableEmoji;
        this.displayableEmoji = displayableEmoji;
    }

    public void renderWidget(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float dt) {
        if (this.displayableEmoji == null) {
            this.disableTooltip();
            return;
        }
        if (!this.wasHovered && this.isHovered) {
            this.changeDisplayableEmoji();
        }
        this.setTooltip(this.displayableEmoji.getEscapedCode());
        Vector2i renderPos = this.getPosition().copyAsMutable();
        int renderSize = this.getWidth();
        if (this.isHovered) {
            renderPos.sub(1, 1);
            renderSize += 2;
        }
        EmojiUtil.render(this.displayableEmoji.getGlyph(), guiGraphics, (Vector2iInterface)renderPos, renderSize, !this.isHovered);
    }

    protected void changeDisplayableEmoji() {
        this.prevDisplayableEmoji = this.displayableEmoji;
        EmojiManager.getInstance().getRandomEmoji().ifPresent(emoji -> {
            this.displayableEmoji = emoji;
        });
        if (this.displayableEmoji == null || this.prevDisplayableEmoji == null) {
            return;
        }
        while (this.displayableEmoji.getName().equals(this.prevDisplayableEmoji.getName())) {
            EmojiManager.getInstance().getRandomEmoji().ifPresent(emoji -> {
                this.displayableEmoji = emoji;
            });
        }
    }
}

