/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg.gui;

import io.github.aratakileo.emogg.EmoggConfig;
import io.github.aratakileo.emogg.emoji.Emoji;
import io.github.aratakileo.emogg.emoji.EmojiManager;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2477;
import net.minecraft.class_310;
import net.minecraft.class_327;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class CategoryContent {
    private final String name;
    @Nullable
    private List<Emoji> emojis;
    private int lineCount;
    private boolean isExpanded;

    public CategoryContent(@NotNull String name) {
        this.name = name;
        this.isExpanded = !EmoggConfig.instance.hiddenCategoryNames.contains(name);
        this.refreshEmojis();
    }

    public boolean isEmpty() {
        return this.emojis == null || this.emojis.isEmpty();
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
        ArrayList<String> hiddenCategoryNames = EmoggConfig.instance.hiddenCategoryNames;
        if (hiddenCategoryNames.contains(this.name)) {
            if (this.isExpanded) {
                hiddenCategoryNames.remove(this.name);
                EmoggConfig.instance.save();
            }
            return;
        }
        if (!this.isExpanded) {
            hiddenCategoryNames.add(this.name);
            EmoggConfig.instance.save();
        }
    }

    public void toggleExpand() {
        this.setExpanded(!this.isExpanded);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getDisplayableName() {
        String categoryLangKey = "emogg.category." + this.name;
        String displayableName = class_2477.method_10517().method_48307(categoryLangKey);
        if (displayableName.equals(categoryLangKey)) {
            return StringUtils.capitalize((String)this.name).replaceAll("_", " ");
        }
        return displayableName;
    }

    @NotNull
    public String getDisplayableName(int maxWidth) {
        class_327 font = class_310.method_1551().field_1772;
        String displayableName = this.getDisplayableName();
        if (font.method_1727(displayableName) <= maxWidth) {
            return displayableName;
        }
        StringBuilder stringBuilder = new StringBuilder(displayableName);
        for (int i = displayableName.length() - 1; i >= 0; --i) {
            stringBuilder.deleteCharAt(i);
            if (font.method_1727(String.valueOf(stringBuilder) + "...") > maxWidth) continue;
            stringBuilder.append("...");
            break;
        }
        return stringBuilder.toString();
    }

    @Nullable
    public List<Emoji> getEmojis() {
        return this.emojis;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public int getRenderLineCount() {
        return this.isExpanded ? this.lineCount : 1;
    }

    public void refreshEmojis() {
        this.emojis = EmojiManager.getInstance().getEmojisByCategory(this.name);
        this.lineCount = (int)(Math.ceil((double)this.emojis.size() / 9.0) + 1.0);
    }
}

