/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg.emoji;

import io.github.aratakileo.emogg.emoji.EmojiGlyph;
import io.github.aratakileo.emogg.emoji.EmojiGlyphProvider;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;

@Environment(value=EnvType.CLIENT)
public class MultiFrameEmojiGlyphProvider
implements EmojiGlyphProvider {
    private final List<Frame> frames;
    private final int totalDuration;

    public MultiFrameEmojiGlyphProvider(List<Frame> frames) {
        this.frames = List.copyOf(frames);
        int time = 0;
        for (Frame frame : this.frames) {
            frame.time = time;
            time += frame.duration;
        }
        this.totalDuration = time;
    }

    @Override
    public EmojiGlyph getGlyph() {
        int time = (int)(class_156.method_658() % (long)this.totalDuration);
        EmojiGlyph last = null;
        for (Frame frame : this.frames) {
            if (frame.time > time) {
                return last;
            }
            last = frame.glyph;
        }
        return last;
    }

    public static class Frame {
        private final EmojiGlyph glyph;
        private final int duration;
        private int time;

        public Frame(EmojiGlyph glyph, int duration) {
            this.glyph = glyph;
            this.duration = duration;
        }
    }
}

