/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg.emoji;

import com.google.common.collect.Lists;
import io.github.aratakileo.emogg.EmoggConfig;
import io.github.aratakileo.emogg.emoji.Emoji;
import io.github.aratakileo.emogg.emoji.EmojiManager;
import io.github.aratakileo.emogg.emoji.EmojiParser;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class FueController {
    public static final String CATEGORY_FREQUENTLY_USED = "$frequently_used";
    private static final int MAX_NUMBER_OF_RECENTLY_USED_EMOJIS = 45;
    private static final int MAX_USES_POINTS = 20;
    private static final int INITIAL_POINTS = 10;

    @NotNull
    public static @NotNull List<@NotNull Emoji> getEmojis() {
        return EmoggConfig.instance.frequentlyUsedEmojis.stream().filter(emojiStatistic -> EmojiManager.getInstance().hasEmoji(emojiStatistic.emojiName)).map(emojiStatistic -> EmojiManager.getInstance().getEmoji(emojiStatistic.emojiName)).toList();
    }

    public static void removeAllNonExistentFue() {
        EmoggConfig.instance.frequentlyUsedEmojis.removeIf(emojiStatistic -> {
            boolean itExists = EmojiManager.getInstance().hasEmoji(emojiStatistic.emojiName);
            return !emojiStatistic.isUnderRemoveProtection(itExists) && !itExists;
        });
        EmoggConfig.instance.save();
    }

    public static void collectStatisticFrom(@NotNull String text) {
        if (text.isEmpty()) {
            return;
        }
        ArrayList emojisNamesInText = Lists.newArrayList();
        for (EmojiParser.Section section : EmojiParser.getEmojiSections(text)) {
            Emoji emoji;
            if (section.escaped() || (emoji = EmojiManager.getInstance().getEmoji(section.emoji())) == null || emojisNamesInText.contains(emoji.getName())) continue;
            emojisNamesInText.add(emoji.getName());
            FueController.markEmojiUse(emoji);
        }
        if (emojisNamesInText.isEmpty()) {
            return;
        }
        for (EmojiStatistic frequentlyUsedEmojiStatistic : Lists.newArrayList(EmoggConfig.instance.frequentlyUsedEmojis)) {
            if (emojisNamesInText.contains(frequentlyUsedEmojiStatistic.emojiName)) continue;
            --frequentlyUsedEmojiStatistic.usePoints;
            if (frequentlyUsedEmojiStatistic.usePoints != 0) continue;
            EmoggConfig.instance.frequentlyUsedEmojis.remove(frequentlyUsedEmojiStatistic);
        }
        EmoggConfig.instance.frequentlyUsedEmojis.sort(Comparator.comparingInt(e -> e.usePoints).reversed());
        EmoggConfig.instance.save();
    }

    private static void markEmojiUse(@NotNull Emoji emoji) {
        String emojiName;
        ArrayList<EmojiStatistic> frequentlyUsedEmojis = EmoggConfig.instance.frequentlyUsedEmojis;
        List<String> frequentlyUsedEmojiNames = FueController.getFueNames();
        if (frequentlyUsedEmojiNames.contains(emojiName = emoji.getName())) {
            EmojiStatistic emojiStatistic = frequentlyUsedEmojis.get(frequentlyUsedEmojiNames.indexOf(emojiName));
            emojiStatistic.usePoints = Math.min(20, emojiStatistic.usePoints + 1);
            return;
        }
        if (frequentlyUsedEmojiNames.size() == 45) {
            frequentlyUsedEmojis.remove(frequentlyUsedEmojiNames.size() - 1);
        }
        frequentlyUsedEmojis.add(new EmojiStatistic(emojiName));
    }

    @NotNull
    private static @NotNull List<@NotNull String> getFueNames() {
        return EmoggConfig.instance.frequentlyUsedEmojis.stream().map(EmojiStatistic::getEmojiName).toList();
    }

    public static class EmojiStatistic {
        public final String emojiName;
        public int usePoints = 10;
        private boolean isUnderRemoveProtection = true;

        public EmojiStatistic(@NotNull String emojiName) {
            this.emojiName = emojiName;
        }

        @NotNull
        public String getEmojiName() {
            return this.emojiName;
        }

        public boolean isUnderRemoveProtection(boolean enableRemoveProtection) {
            boolean isUnderRemoveProtectionOld = this.isUnderRemoveProtection;
            this.isUnderRemoveProtection = enableRemoveProtection;
            return isUnderRemoveProtectionOld;
        }
    }
}

