/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg.emoji;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.aratakileo.emogg.Emogg;
import io.github.aratakileo.emogg.EmoggConfig;
import io.github.aratakileo.emogg.emoji.Emoji;
import io.github.aratakileo.emogg.emoji.EmojiFontSet;
import io.github.aratakileo.emogg.emoji.EmojiInteractions;
import io.github.aratakileo.emogg.emoji.EmojiManager;
import io.github.aratakileo.emogg.util.WeakIdentityHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
public class EmojiParser {
    public static final Pattern PATTERN = Pattern.compile("(\\\\?)[:\uff1a]([_A-Za-z0-9]+)[:\uff1a]");
    private static final WeakIdentityHashMap<class_5250, class_5250> parsedToOriginal = new WeakIdentityHashMap();
    private static boolean parsing = false;
    public static boolean isInGetString = false;

    public static List<Section> getEmojiSections(String text) {
        Matcher matcher = PATTERN.matcher(text);
        ArrayList<Section> sections = new ArrayList<Section>();
        while (matcher.find()) {
            sections.add(new Section(matcher.start(), matcher.end(), matcher.group(2), !matcher.group(1).isEmpty()));
        }
        return sections;
    }

    private static void _parse(class_5250 component) {
        class_7417 class_74172 = component.method_10851();
        if (class_74172 instanceof class_2585) {
            class_2585 literalContents = (class_2585)class_74172;
            String originalText = literalContents.comp_737();
            List<Section> sections = EmojiParser.getEmojiSections(originalText);
            if (sections.isEmpty()) {
                return;
            }
            if (EmoggConfig.instance.enableDebugMode) {
                Emogg.LOGGER.debug("Parsing <" + String.valueOf(component) + ">");
            }
            parsedToOriginal.put(component, component.method_27661());
            ArrayList<class_5250> components = new ArrayList<class_5250>();
            StringBuilder stringBuilder = new StringBuilder();
            int lastEnd = 0;
            for (int i = 0; i < sections.size() + 1; ++i) {
                if (i != sections.size()) {
                    Section section = sections.get(i);
                    stringBuilder.append(originalText, lastEnd, section.start());
                    if (!section.escaped()) {
                        Emoji emoji = EmojiManager.getInstance().getEmoji(section.emoji());
                        if (emoji == null) continue;
                        if (!stringBuilder.isEmpty()) {
                            components.add(class_5250.method_43477((class_7417)new class_2585(stringBuilder.toString())));
                            stringBuilder.setLength(0);
                        }
                        lastEnd = section.end();
                        class_5250 emojiComponent = class_5250.method_43477((class_7417)new class_2585(Character.toString(EmojiFontSet.idToCodePoint(emoji.getId()))));
                        emojiComponent.method_10862(class_2583.field_24360.method_27704(EmojiFontSet.NAME).method_10949((class_2568)EmojiInteractions.EmojiHoverEvent.of(emoji)).method_10958((class_2558)EmojiInteractions.EmojiClickEvent.of(emoji)));
                        components.add(emojiComponent);
                        continue;
                    }
                    stringBuilder.append(originalText, section.start() + 1, section.end());
                    lastEnd = section.end();
                    continue;
                }
                stringBuilder.append(originalText, lastEnd, originalText.length());
            }
            components.add(class_5250.method_43477((class_7417)new class_2585(stringBuilder.toString())));
            components.addAll(component.method_10855());
            component.field_39006 = components;
            component.field_39005 = class_7417.field_39004;
            if (EmoggConfig.instance.enableDebugMode) {
                Emogg.LOGGER.debug("Parse result: <" + String.valueOf(component) + ">");
            }
        }
    }

    public static void parse(class_5250 component) {
        if (!EmojiParser.isParsable((class_2561)component)) {
            return;
        }
        if (parsedToOriginal.containsKey(component)) {
            return;
        }
        try {
            if (!parsing) {
                parsing = true;
                EmojiParser._parse(component);
                parsing = false;
            }
        }
        catch (Exception e) {
            parsing = false;
            Emogg.LOGGER.warn("Failed to parse component <" + String.valueOf(component) + ">", (Throwable)e);
        }
    }

    public static boolean isParsable(class_2561 component) {
        return component instanceof class_5250 && component.method_10851() instanceof class_2585;
    }

    public static boolean mayBeParseResult(class_2561 component) {
        return component instanceof class_5250 && component.method_10851() == class_7417.field_39004;
    }

    public static boolean isOnLogicalClient() {
        return RenderSystem.isOnRenderThreadOrInit();
    }

    @Nullable
    public static class_5250 getOriginal(class_2561 component) {
        if (!EmojiParser.mayBeParseResult(component)) {
            return null;
        }
        return parsedToOriginal.get((class_5250)component);
    }

    public static <T> void mixinApplyUsingOriginal(class_2561 component, CallbackInfoReturnable<T> cir, Function<class_2561, T> operation, String debugLogPrefix) {
        class_5250 original = EmojiParser.getOriginal(component);
        if (original != null) {
            if (EmoggConfig.instance.enableDebugMode) {
                Emogg.LOGGER.info(debugLogPrefix + "original:<{}> transformed:<{}>", (Object)original, (Object)component);
            }
            cir.cancel();
            cir.setReturnValue(operation.apply((class_2561)original));
        }
    }

    public record Section(int start, int end, String emoji, boolean escaped) {
    }
}

