/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg.emoji;

import com.google.common.collect.Lists;
import io.github.aratakileo.elegantia.event.ResourceReloadListener;
import io.github.aratakileo.emogg.Emogg;
import io.github.aratakileo.emogg.EmoggConfig;
import io.github.aratakileo.emogg.emoji.Emoji;
import io.github.aratakileo.emogg.emoji.EmojiAtlas;
import io.github.aratakileo.emogg.emoji.FueController;
import io.github.aratakileo.emogg.util.EmojiUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EmojiManager {
    @Nullable
    private static EmojiManager instance;
    public static final Predicate<@NotNull String> HAS_EMOJIS_EXTENSION;
    public static final Predicate<@NotNull class_2960> IS_EMOJI_LOCATION;
    private final ConcurrentHashMap<@NotNull Integer, @NotNull Emoji> emojiById = new ConcurrentHashMap();
    private final ConcurrentHashMap<@NotNull String, @NotNull Emoji> emojiByName = new ConcurrentHashMap();
    private final Map<@NotNull String, @NotNull Integer> nameToIdMap = new HashMap<String, Integer>();
    private final ConcurrentHashMap<@NotNull String, @NotNull List<@NotNull String>> emojiCategories = new ConcurrentHashMap();

    private EmojiManager() {
    }

    public boolean isEmpty() {
        return this.emojiByName.isEmpty();
    }

    public boolean hasEmoji(int id) {
        return this.emojiById.containsKey(id);
    }

    public boolean hasEmoji(@NotNull String name) {
        return this.emojiByName.containsKey(name);
    }

    @Nullable
    public Emoji getEmoji(int id) {
        return this.emojiById.get(id);
    }

    @Nullable
    public Emoji getEmoji(@NotNull String name) {
        return this.emojiByName.get(name);
    }

    public boolean hasCategory(@NotNull String categoryKey) {
        return this.emojiCategories.containsKey(categoryKey);
    }

    @NotNull
    public List<String> getCategoryKeys() {
        return this.emojiCategories.keySet().stream().toList();
    }

    public @Nullable List<@NotNull Emoji> getEmojisByCategory(@NotNull String name) {
        if (name.equals("$frequently_used")) {
            return FueController.getEmojis();
        }
        if (!this.emojiCategories.containsKey(name)) {
            return null;
        }
        return this.emojiCategories.get(name).stream().map(this.emojiByName::get).toList();
    }

    @NotNull
    public @NotNull Stream<@NotNull Emoji> getEmojisStream() {
        return Lists.newArrayList(this.emojiByName.values()).stream();
    }

    @NotNull
    public Optional<Emoji> getRandomEmoji() {
        return this.emojiByName.values().stream().skip((int)((double)this.emojiByName.size() * Math.random())).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regEmoji(@NotNull class_2960 resourceLocation) {
        int id;
        String emojiName = this.getUniqueName(EmojiUtil.normalizeEmojiObjectKey(EmojiUtil.getNameFromPath(resourceLocation)));
        Map<String, Integer> map = this.nameToIdMap;
        synchronized (map) {
            id = this.nameToIdMap.computeIfAbsent(emojiName, name -> this.nameToIdMap.size());
        }
        Emoji emoji = Emoji.fromResource(id, emojiName, resourceLocation);
        this.emojiByName.put(emojiName, emoji);
        this.emojiById.put(emoji.getId(), emoji);
        this.regEmojiInItsCategory(emoji);
        if (EmoggConfig.instance.enableDebugMode) {
            Emogg.LOGGER.info(String.format("Discovered \"%s\" as %s to category <%s>", resourceLocation, emoji.getCode(), emoji.getCategory()));
        }
    }

    @NotNull
    private String getUniqueName(@NotNull String emojiName) {
        if (this.emojiByName.containsKey(emojiName)) {
            int emojiNameIndex = 0;
            String newEmojiName = emojiName + emojiNameIndex;
            while (this.emojiByName.containsKey(newEmojiName)) {
                newEmojiName = emojiName + ++emojiNameIndex;
            }
            return newEmojiName;
        }
        return emojiName;
    }

    private void regEmojiInItsCategory(@NotNull Emoji emoji) {
        List<String> emojiNamesInCategory;
        if (!this.emojiCategories.containsKey(emoji.getCategory())) {
            this.emojiCategories.put(emoji.getCategory(), new ArrayList());
        }
        if ((emojiNamesInCategory = this.emojiCategories.get(emoji.getCategory())).contains(emoji.getName())) {
            return;
        }
        emojiNamesInCategory.add(emoji.getName());
    }

    private void onResourceReload(@NotNull class_3300 resourceManager) {
        long startsLoadingAt = System.currentTimeMillis();
        if (EmoggConfig.instance.enableDebugMode) {
            Emogg.LOGGER.info("[emogg] Updating emoji lists...");
        }
        EmojiAtlas.clear();
        this.emojiCategories.clear();
        this.emojiById.clear();
        this.emojiByName.clear();
        resourceManager.method_14488("emoji", IS_EMOJI_LOCATION).keySet().forEach(this::regEmoji);
        this.emojiCategories.values().forEach(Collections::sort);
        Emogg.LOGGER.info(String.format("[emogg] The emoji list has been updated. Discovered %s emojis in %ss!", this.emojiByName.size(), (double)(System.currentTimeMillis() - startsLoadingAt) / 1000.0));
        FueController.removeAllNonExistentFue();
    }

    public static void init() {
        instance = new EmojiManager();
        ResourceReloadListener.register(instance::onResourceReload);
    }

    @NotNull
    public static EmojiManager getInstance() {
        if (instance == null) {
            throw new NullPointerException("EmojiManager not initialized!");
        }
        return instance;
    }

    static {
        HAS_EMOJIS_EXTENSION = path -> path.endsWith(".png") || path.endsWith(".gif");
        IS_EMOJI_LOCATION = resourceLocation -> HAS_EMOJIS_EXTENSION.test(resourceLocation.method_12832());
    }
}

