/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg.emoji;

import io.github.aratakileo.elegantia.graphics.NativeGifImage;
import io.github.aratakileo.emogg.emoji.EmojiAtlas;
import io.github.aratakileo.emogg.emoji.EmojiGlyph;
import io.github.aratakileo.emogg.emoji.EmojiGlyphProvider;
import io.github.aratakileo.emogg.emoji.MultiFrameEmojiGlyphProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;

@FunctionalInterface
@Environment(value=EnvType.CLIENT)
public interface EmojiLoader {
    public Future<? extends EmojiGlyphProvider> load();

    public static CompletableFuture<InputStream> resourceReader(class_2960 location) {
        return CompletableFuture.supplyAsync(() -> {
            class_3298 resource = (class_3298)class_310.method_1551().method_1478().method_14486(location).orElseThrow(() -> new EmojiLoadingException("Resource not found: " + String.valueOf(location)));
            try {
                return resource.method_14482();
            }
            catch (IOException e) {
                throw new EmojiLoadingException("Failed to open resource: " + String.valueOf(location), e);
            }
        }, class_156.method_27958());
    }

    public static CompletableFuture<InputStream> downloader(URL url) {
        return null;
    }

    public static CompletableFuture<InputStream> fileReader(File file) {
        return null;
    }

    public static CompletableFuture<EmojiGlyphProvider> staticImageLoader(CompletableFuture<InputStream> loader) {
        return ((CompletableFuture)loader.thenApply(inputStream -> {
            class_1011 class_10112;
            block10: {
                class_1011 image = null;
                InputStream inputStream2 = inputStream;
                try {
                    image = class_1011.method_4309((InputStream)inputStream);
                    if (image.method_4307() <= 0 || image.method_4323() <= 0) {
                        throw new EmojiLoadingException("Invalid PNG image!");
                    }
                    class_10112 = image;
                    if (inputStream2 == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        if (image != null) {
                            image.close();
                        }
                        throw new EmojiLoadingException("Failed to load PNG image", e);
                    }
                }
                inputStream2.close();
            }
            return class_10112;
        })).thenApplyAsync(image -> {
            EmojiGlyph.Atlas glyph = EmojiAtlas.stitch(image);
            image.close();
            return () -> glyph;
        }, (Executor)class_310.method_1551());
    }

    public static CompletableFuture<MultiFrameEmojiGlyphProvider> gifLoader(CompletableFuture<InputStream> loader) {
        return ((CompletableFuture)loader.thenApply(inputStream -> {
            NativeGifImage nativeGifImage;
            block10: {
                NativeGifImage gif = null;
                InputStream inputStream2 = inputStream;
                try {
                    gif = NativeGifImage.read((InputStream)inputStream);
                    if (gif.getFrameCount() <= 0 || gif.getWidth() <= 0 || gif.getHeight() <= 0) {
                        throw new EmojiLoadingException("Invalid GIF image!");
                    }
                    nativeGifImage = gif;
                    if (inputStream2 == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        if (gif != null) {
                            gif.close();
                        }
                        throw new EmojiLoadingException("Failed to load GIF image", e);
                    }
                }
                inputStream2.close();
            }
            return nativeGifImage;
        })).thenApplyAsync(gif -> {
            ArrayList<MultiFrameEmojiGlyphProvider.Frame> frames = new ArrayList<MultiFrameEmojiGlyphProvider.Frame>();
            gif.processFrames((index, time, frame) -> {
                frames.add(new MultiFrameEmojiGlyphProvider.Frame(EmojiAtlas.stitch(frame.nativeImage()), frame.delay()));
                frame.nativeImage().close();
            });
            return new MultiFrameEmojiGlyphProvider(frames);
        }, (Executor)class_310.method_1551());
    }

    public static class EmojiLoadingException
    extends RuntimeException {
        public EmojiLoadingException(String message) {
            super(message);
        }

        public EmojiLoadingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

