/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg.emoji;

import io.github.aratakileo.elegantia.math.Rect2i;
import io.github.aratakileo.emogg.EmoggRenderTypes;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1047;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_379;
import net.minecraft.class_382;
import net.minecraft.class_383;
import net.minecraft.class_4588;
import net.minecraft.class_8538;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

@Environment(value=EnvType.CLIENT)
public abstract class EmojiGlyph
extends class_382
implements class_379 {
    public static final float HEIGHT = 8.0f;
    public static final float ITALIC_SHEAR = 0.25f;
    private static final Matrix4f tempMat = new Matrix4f();
    public static final EmojiGlyph ERROR = new Error();
    public static final EmojiGlyph LOADING = new Loading();
    public static final EmojiGlyph EMPTY = new Empty();

    public EmojiGlyph(class_8538 glyphRenderTypes) {
        super(glyphRenderTypes, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public abstract float getAspectRatio();

    protected boolean coloredByDefault() {
        return false;
    }

    private void setupMatrix(boolean italic, float x, float y, Matrix4f mat) {
        tempMat.set(8.0f * this.getAspectRatio(), 0.0f, 0.0f, 0.0f, italic ? -2.0f : 0.0f, 8.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, x + (italic ? 2.0f : 0.0f), y, 0.0f, 1.0f);
        tempMat.mulLocal((Matrix4fc)mat);
    }

    public final void method_2025(boolean italic, float x, float y, Matrix4f mat, class_4588 builder, float r, float g, float b, float a, int packedLightCoords) {
        this.setupMatrix(italic, x, y, mat);
        if (!this.coloredByDefault()) {
            b = 1.0f;
            g = 1.0f;
            r = 1.0f;
        }
        this.renderImpl(builder, tempMat, r, g, b, a, packedLightCoords);
    }

    public final void renderColored(boolean italic, float x, float y, Matrix4f mat, class_4588 builder, float r, float g, float b, float a, int packedLightCoords) {
        this.setupMatrix(italic, x, y, mat);
        this.renderImpl(builder, tempMat, r, g, b, a, packedLightCoords);
    }

    protected abstract void renderImpl(class_4588 var1, Matrix4f var2, float var3, float var4, float var5, float var6, int var7);

    public final float getAdvance() {
        return 8.0f * this.getAspectRatio();
    }

    public final float method_16798(boolean bl) {
        return this.getAdvance();
    }

    public final float method_16799() {
        return 0.0f;
    }

    public final float method_16800() {
        return 0.0f;
    }

    @NotNull
    public final class_382 bake(Function<class_383, class_382> function) {
        return this;
    }

    private static class Error
    extends TexturedEmojiGlyph {
        private Error() {
            super(class_1047.method_4539());
        }

        @Override
        public float getAspectRatio() {
            return 1.0f;
        }

        @Override
        protected void renderImpl(class_4588 builder, Matrix4f mat, float r, float g, float b, float a, int packedLightCoords) {
            super.renderImpl(builder, mat, r, g, b, a, packedLightCoords);
        }
    }

    private static class Loading
    extends RectEmojiGlyph {
        public Loading() {
            super(EmoggRenderTypes.emojiLoading());
        }

        @Override
        public float getAspectRatio() {
            return 1.0f;
        }

        @Override
        protected void renderImpl(class_4588 builder, Matrix4f mat, float r, float g, float b, float a, int packedLightCoords) {
            int ANIMATION_LENGTH = 2000;
            EmoggRenderTypes.Shaders.Uniform.loadingAnimationTime.method_1251((float)(class_156.method_658() % 2000L) / 2000.0f);
            super.renderImpl(builder, mat, r, g, b, a, packedLightCoords);
        }
    }

    private static class Empty
    extends EmojiGlyph {
        private Empty() {
            super(EmoggRenderTypes.emojiNoTexture());
        }

        @Override
        public float getAspectRatio() {
            return 1.0f;
        }

        @Override
        protected void renderImpl(class_4588 builder, Matrix4f mat, float r, float g, float b, float a, int packedLightCoords) {
        }
    }

    public static class Atlas
    extends TexturedEmojiGlyph {
        private final Rect2i rect;

        protected Atlas(class_2960 texture, Rect2i rect) {
            super(texture);
            this.rect = rect;
        }

        void updateUV(int atlasWidth, int atlasHeight) {
            this.field_2276 = (float)this.rect.method_3321() / (float)atlasWidth;
            this.field_2274 = (float)this.rect.method_3322() / (float)atlasHeight;
            this.field_2275 = (float)this.rect.getRight() / (float)atlasWidth;
            this.field_2273 = (float)this.rect.getBottom() / (float)atlasHeight;
        }

        @Override
        public float getAspectRatio() {
            return (float)this.rect.method_3319() / (float)this.rect.method_3320();
        }

        @Override
        protected void renderImpl(class_4588 builder, Matrix4f mat, float r, float g, float b, float a, int packedLightCoords) {
            super.renderImpl(builder, mat, r, g, b, a, packedLightCoords);
        }
    }

    public static abstract class TexturedEmojiGlyph
    extends RectEmojiGlyph {
        private final class_2960 texture;

        public TexturedEmojiGlyph(class_2960 texture) {
            super(EmoggRenderTypes.emojiTextured(texture));
            this.texture = texture;
        }

        public class_1921 grayScaleRenderType(class_327.class_6415 mode) {
            return EmoggRenderTypes.emojiTexturedGrayscale(this.texture).method_51642(mode);
        }
    }

    private static abstract class RectEmojiGlyph
    extends EmojiGlyph {
        public RectEmojiGlyph(class_8538 glyphRenderTypes) {
            super(glyphRenderTypes);
            this.field_2274 = 0.0f;
            this.field_2276 = 0.0f;
            this.field_2273 = 1.0f;
            this.field_2275 = 1.0f;
        }

        @Override
        protected void renderImpl(class_4588 builder, Matrix4f mat, float r, float g, float b, float a, int packedLightCoords) {
            builder.method_22918(mat, 0.0f, 0.0f, 0.0f).method_22915(r, g, b, a).method_22913(this.field_2276, this.field_2274).method_22916(packedLightCoords).method_1344();
            builder.method_22918(mat, 0.0f, 1.0f, 0.0f).method_22915(r, g, b, a).method_22913(this.field_2276, this.field_2273).method_22916(packedLightCoords).method_1344();
            builder.method_22918(mat, 1.0f, 1.0f, 0.0f).method_22915(r, g, b, a).method_22913(this.field_2275, this.field_2273).method_22916(packedLightCoords).method_1344();
            builder.method_22918(mat, 1.0f, 0.0f, 0.0f).method_22915(r, g, b, a).method_22913(this.field_2275, this.field_2274).method_22916(packedLightCoords).method_1344();
        }
    }
}

