/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg.emoji;

import com.google.common.collect.Lists;
import io.github.aratakileo.emogg.emoji.EmojiManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface EmojiCategory {
    public static final String DEFAULT = "other";
    public static final String ANIME = "anime";
    public static final String MEMES = "memes";
    public static final String PEOPLE = "people";
    public static final String NATURE = "nature";
    public static final String FOOD = "food";
    public static final String ACTIVITIES = "activities";
    public static final String TRAVEL = "travel";
    public static final String OBJECTS = "objects";
    public static final String SYMBOLS = "symbols";
    public static final String FLAGS = "flags";

    @NotNull
    public static List<String> getCategoryKeys(boolean sort) {
        if (!sort) {
            return EmojiManager.getInstance().getCategoryKeys();
        }
        ArrayList categoryKeys = Lists.newArrayList(EmojiManager.getInstance().getCategoryKeys());
        Collections.sort(categoryKeys);
        for (String categoryKey : EmojiCategory.getBuiltinCategoryKeys()) {
            if (!categoryKeys.contains(categoryKey)) continue;
            categoryKeys.remove(categoryKey);
            categoryKeys.add(categoryKey);
        }
        if (categoryKeys.contains("$frequently_used")) {
            categoryKeys.remove("$frequently_used");
            categoryKeys.add(0, "$frequently_used");
        }
        return categoryKeys;
    }

    @NotNull
    public static List<String> getBuiltinCategoryKeys() {
        return List.of(ANIME, MEMES, PEOPLE, NATURE, FOOD, ACTIVITIES, TRAVEL, OBJECTS, SYMBOLS, FLAGS, DEFAULT);
    }
}

