/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg.emoji;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.aratakileo.elegantia.event.HudRenderListener;
import io.github.aratakileo.elegantia.graphics.RectDrawer;
import io.github.aratakileo.elegantia.math.Rect2i;
import io.github.aratakileo.elegantia.math.Vector2iInterface;
import io.github.aratakileo.elegantia.math.Vector2ic;
import io.github.aratakileo.emogg.Emogg;
import io.github.aratakileo.emogg.EmoggConfig;
import io.github.aratakileo.emogg.emoji.EmojiGlyph;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_8215;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EmojiAtlas {
    private static final String NAME = "emoji_atlas_%d";
    private static final List<EmojiAtlasTexture> textures = new ArrayList<EmojiAtlasTexture>();

    @NotNull
    public static EmojiGlyph.Atlas stitch(class_1011 image) {
        RenderSystem.assertOnRenderThreadOrInit();
        for (EmojiAtlasTexture texture : textures) {
            EmojiGlyph.Atlas glyph = texture.stitch(image);
            if (glyph == null) continue;
            return glyph;
        }
        EmojiAtlasTexture texture = new EmojiAtlasTexture(NAME.formatted(textures.size()));
        textures.add(texture);
        return Objects.requireNonNull(texture.stitch(image));
    }

    public static void clear() {
        textures.forEach(class_1044::close);
        textures.clear();
    }

    static {
        HudRenderListener.EVENT.register((guiGraphics, dt) -> {
            if (EmoggConfig.instance.enableAtlasDebugHUD && !textures.isEmpty()) {
                textures.get(textures.size() - 1).drawDebugHUD(guiGraphics);
            }
        });
    }

    private static class EmojiAtlasTexture
    extends class_1044
    implements class_8215 {
        private final class_2960 resourceLocation;
        private int totalWidth = 256;
        private int totalHeight = 256;
        private final LinkedList<Rect2i> freeSpace = new LinkedList();
        private final Collection<EmojiGlyph.Atlas> stitchedGlyphs = new ArrayList<EmojiGlyph.Atlas>();
        private static final int BG_FILL_COLOR = 0;

        public EmojiAtlasTexture(@NotNull String name) {
            RenderSystem.assertOnRenderThreadOrInit();
            this.resourceLocation = new class_2960("emogg", name);
            class_310.method_1551().method_1531().method_4616(this.resourceLocation, (class_1044)this);
            TextureUtil.prepareImage((class_1011.class_1013)class_1011.class_1013.field_5012, (int)this.method_4624(), (int)this.totalWidth, (int)this.totalHeight);
            this.fillBackground();
            this.freeSpace.add(new Rect2i(0, 0, this.totalWidth, this.totalHeight));
            Emogg.LOGGER.info("Created emoji atlas texture: {}x{} {}", new Object[]{this.totalWidth, this.totalHeight, this.getResourceLocation()});
        }

        public void method_4625(@NotNull class_3300 resourceManager) {
        }

        @Nullable
        public EmojiGlyph.Atlas stitch(@NotNull class_1011 image) {
            Vector2ic pos;
            RenderSystem.assertOnRenderThreadOrInit();
            while ((pos = this.fit(image.method_4307(), image.method_4323(), 1)) == null) {
                if (this.expand()) continue;
                return null;
            }
            if (EmoggConfig.instance.enableDebugMode) {
                Emogg.LOGGER.info("Stitching emoji texture to ({})", (Object)pos);
            }
            this.method_23207();
            image.method_4301(0, pos.x, pos.y, false);
            EmojiGlyph.Atlas glyph = new EmojiGlyph.Atlas(this.resourceLocation, new Rect2i((Vector2iInterface)pos, image.method_4307(), image.method_4323()));
            glyph.updateUV(this.totalWidth, this.totalHeight);
            this.stitchedGlyphs.add(glyph);
            return glyph;
        }

        @Nullable
        private Vector2ic fit(int width, int height, int padding) {
            width += padding * 2;
            height += padding * 2;
            ListIterator iter = this.freeSpace.listIterator();
            while (iter.hasNext()) {
                Rect2i toAdd;
                double ratioB;
                Rect2i rect = (Rect2i)iter.next();
                if (rect.method_3319() < width || rect.method_3320() < height) continue;
                Vector2ic pos = rect.getPosition().add(padding, padding);
                double ratioA0 = (double)(rect.method_3319() - width) / (double)height;
                double ratioA1 = (double)rect.method_3319() / (double)(rect.method_3320() - height);
                double ratioB0 = (double)width / (double)(rect.method_3320() - height);
                double ratioB1 = (double)(rect.method_3319() - width) / (double)rect.method_3320();
                double ratioA = Math.max(ratioA0 > 1.0 ? ratioA0 : 1.0 / ratioA0, ratioA1 > 1.0 ? ratioA1 : 1.0 / ratioA1);
                if (ratioA < (ratioB = Math.max(ratioB0 > 1.0 ? ratioB0 : 1.0 / ratioB0, ratioB1 > 1.0 ? ratioB1 : 1.0 / ratioB1))) {
                    toAdd = rect.cutLeft(width).setIpHeight(height);
                    rect.cutIpTop(height);
                } else {
                    toAdd = rect.cutTop(height).setIpWidth(width);
                    rect.cutIpLeft(width);
                }
                iter.remove();
                if (rect.isExist()) {
                    this.freeSpace.addFirst(rect);
                }
                if (toAdd.isExist()) {
                    this.freeSpace.addFirst(toAdd);
                }
                return pos;
            }
            return null;
        }

        private boolean expand() {
            RenderSystem.assertOnRenderThreadOrInit();
            int limit = RenderSystem.maxSupportedTextureSize();
            if (this.totalWidth == limit && this.totalHeight == limit) {
                return false;
            }
            int oldWidth = this.totalWidth;
            int oldHeight = this.totalHeight;
            if (this.totalWidth <= this.totalHeight) {
                this.totalWidth = Math.min(this.totalWidth * 2, limit);
                this.freeSpace.add(new Rect2i(oldWidth, 0, this.totalWidth - oldWidth, this.totalHeight));
            } else {
                this.totalHeight = Math.min(this.totalHeight * 2, limit);
                this.freeSpace.add(new Rect2i(0, oldHeight, this.totalWidth, this.totalHeight - oldHeight));
            }
            if (EmoggConfig.instance.enableDebugMode) {
                Emogg.LOGGER.info("Expanding emoji atlas: %dx%d -> %dx%d".formatted(oldWidth, oldHeight, this.totalWidth, this.totalHeight));
            }
            this.method_23207();
            class_1011 image = new class_1011(class_1011.class_1012.field_4997, oldWidth, oldHeight, false);
            image.method_4327(0, false);
            this.method_4528();
            TextureUtil.prepareImage((class_1011.class_1013)class_1011.class_1013.field_5012, (int)this.method_4624(), (int)this.totalWidth, (int)this.totalHeight);
            this.fillBackground();
            this.method_23207();
            image.method_4301(0, 0, 0, false);
            image.close();
            this.stitchedGlyphs.forEach(glyph -> glyph.updateUV(this.totalWidth, this.totalHeight));
            return true;
        }

        private void fillBackground() {
            try (class_1011 image = new class_1011(class_1011.class_1012.field_4997, this.totalWidth, this.totalHeight, false);){
                image.method_4326(0, 0, this.totalWidth, this.totalHeight, 0);
                this.method_23207();
                image.method_4301(0, 0, 0, false);
            }
        }

        private void _debugDrawFreeSpace() {
            RenderSystem.assertOnRenderThreadOrInit();
            class_1011 image = new class_1011(class_1011.class_1012.field_4997, this.totalWidth, this.totalHeight, false);
            Random random = new Random();
            for (Rect2i rect : this.freeSpace) {
                try {
                    image.method_4326(rect.method_3321(), rect.method_3322(), rect.method_3319() - 1, rect.method_3320() - 1, random.nextInt(0x1000000) | 0xFF000000);
                }
                catch (IllegalArgumentException e) {
                    Emogg.LOGGER.warn(e.toString());
                }
            }
            this.method_23207();
            image.method_4301(0, 0, 0, false);
            image.close();
        }

        public void method_49712(@NotNull class_2960 resourceLocation, @NotNull Path path) {
            TextureUtil.writeAsPNG((Path)path, (String)resourceLocation.method_36181(), (int)this.method_4624(), (int)0, (int)this.totalWidth, (int)this.totalHeight);
        }

        public class_2960 getResourceLocation() {
            return this.resourceLocation;
        }

        public void drawDebugHUD(@NotNull class_332 guiGraphics) {
            double scale = (double)guiGraphics.method_51443() / (double)this.totalHeight;
            guiGraphics.method_25293(this.getResourceLocation(), 0, 0, (int)((double)this.totalWidth * scale), (int)((double)this.totalHeight * scale), 0.0f, 0.0f, this.totalWidth, this.totalHeight, this.totalWidth, this.totalHeight);
            Random random = new Random();
            for (Rect2i rect : this.freeSpace) {
                random.setSeed(rect.hashCode());
                RectDrawer.with((class_332)guiGraphics, (Rect2i)rect.mul(scale)).draw(random.nextInt(0, 0x1000000) | Integer.MIN_VALUE);
            }
        }
    }
}

