/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg.emoji;

import io.github.aratakileo.emogg.Emogg;
import io.github.aratakileo.emogg.emoji.EmojiGlyph;
import io.github.aratakileo.emogg.emoji.EmojiGlyphProvider;
import io.github.aratakileo.emogg.emoji.EmojiLoader;
import io.github.aratakileo.emogg.util.EmojiUtil;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public final class Emoji {
    private final int id;
    private final String name;
    private final String category;
    private final EmojiLoader loader;
    private Future<? extends EmojiGlyphProvider> loadingFuture = null;
    private EmojiGlyphProvider glyphProvider = null;
    private String loadError = null;
    private State state = State.INACTIVE;

    private Emoji(int id, @NotNull String name, @NotNull String category, @NotNull EmojiLoader loader) {
        this.id = id;
        this.name = name;
        this.category = category;
        this.loader = loader;
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getCategory() {
        return this.category;
    }

    @NotNull
    public String getCode() {
        return ":" + this.name + ":";
    }

    @NotNull
    public String getEscapedCode() {
        return "\\" + this.getCode();
    }

    public State getState() {
        return this.state;
    }

    public String getLoadError() {
        return this.loadError;
    }

    @NotNull
    public EmojiGlyph getGlyph() {
        EmojiGlyph glyph;
        this.updateLoadingState();
        switch (this.state) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LOADING: {
                EmojiGlyph emojiGlyph = EmojiGlyph.LOADING;
                break;
            }
            case ERROR: {
                EmojiGlyph emojiGlyph = EmojiGlyph.ERROR;
                break;
            }
            case ACTIVE: {
                EmojiGlyph emojiGlyph = this.glyphProvider.getGlyph();
                break;
            }
            case INACTIVE: {
                Emogg.LOGGER.warn("Emoji " + String.valueOf(this) + " shouldn't be inactive when rendering!");
                EmojiGlyph emojiGlyph = glyph = EmojiGlyph.EMPTY;
            }
        }
        if (glyph == null) {
            Emogg.LOGGER.warn("Failed to get glyph for emoji " + String.valueOf(this) + ": null");
            return EmojiGlyph.ERROR;
        }
        return glyph;
    }

    private void updateLoadingState() {
        if (this.state == State.INACTIVE) {
            this.loadingFuture = this.loader.load();
            this.state = State.LOADING;
        }
        if (this.state != State.LOADING || !this.loadingFuture.isDone()) {
            return;
        }
        try {
            this.glyphProvider = this.loadingFuture.get();
            this.state = State.ACTIVE;
        }
        catch (ExecutionException e) {
            Emogg.LOGGER.warn("Emoji " + this.getCode() + " loading failed!", e.getCause());
            this.loadError = e.getCause().toString();
            this.state = State.ERROR;
        }
        catch (InterruptedException | CancellationException e) {
            Emogg.LOGGER.warn("Emoji " + this.getCode() + " loading failed!", (Throwable)e);
            this.loadError = e.toString();
            this.state = State.ERROR;
        }
    }

    public void reload(boolean forceLoadImmediately) {
        this.state = State.INACTIVE;
        if (this.loadingFuture != null && !this.loadingFuture.isDone()) {
            this.loadingFuture.cancel(true);
        }
        this.loadingFuture = null;
        this.glyphProvider = null;
        this.loadError = null;
        if (forceLoadImmediately) {
            this.forceLoad();
        }
    }

    public void forceLoad() {
        this.updateLoadingState();
    }

    @NotNull
    public static Emoji fromResource(int id, @NotNull String name, @NotNull class_2960 resourceLocation) {
        String category = resourceLocation.method_12832().substring("emoji".length() + 1);
        if (category.contains("/")) {
            String[] splitPath = category.split("/");
            category = splitPath[splitPath.length - 2];
        } else {
            category = "other";
        }
        EmojiLoader loader = resourceLocation.method_12832().endsWith(".gif") ? () -> EmojiLoader.gifLoader(EmojiLoader.resourceReader(resourceLocation)) : () -> EmojiLoader.staticImageLoader(EmojiLoader.resourceReader(resourceLocation));
        return new Emoji(id, EmojiUtil.normalizeEmojiObjectKey(name), EmojiUtil.normalizeEmojiObjectKey(category.equals("default") ? "other" : category), loader);
    }

    public static enum State {
        INACTIVE,
        LOADING,
        ACTIVE,
        ERROR;

    }
}

