/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg;

import com.mojang.datafixers.util.Pair;
import io.github.aratakileo.emogg.Emogg;
import io.github.aratakileo.emogg.EmoggConfig;
import io.github.aratakileo.emogg.util.MultiUniform;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4668;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_8538;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EmoggRenderTypes {
    private static boolean customShadersAvailable = false;
    private static final Function<class_2960, class_8538> EMOJI_TEXTURED = class_156.method_34866(texture -> EmoggRenderTypes.createGlyphRT("emoji_textured", class_293.class_5596.field_27382, Shaders.EMOJI_TEXTURED, Shaders.EMOJI_TEXTURED_SEE_THROUGH, texture, true));
    private static final Function<class_2960, class_8538> EMOJI_TEXTURED_VANILLA = class_156.method_34866(texture -> EmoggRenderTypes.createGlyphRT("emoji_textured_vanilla", class_293.class_5596.field_27382, class_4668.field_29427, class_4668.field_29428, texture, true));
    private static final Function<class_2960, class_8538> EMOJI_TEXTURED_GRAYSCALE = class_156.method_34866(texture -> EmoggRenderTypes.createGlyphRT("emoji_textured_grayscale", class_293.class_5596.field_27382, Shaders.EMOJI_TEXTURED_GRAYSCALE, Shaders.EMOJI_TEXTURED_GRAYSCALE_SEE_THROUGH, texture, true));
    private static final class_8538 EMOJI_NO_TEXTURE = EmoggRenderTypes.createGlyphRT("emoji_no_texture", class_293.class_5596.field_27379, Shaders.EMOJI_NO_TEXTURE, Shaders.EMOJI_NO_TEXTURE_SEE_THROUGH, null, false);
    private static final class_8538 EMOJI_NO_TEXTURE_VANILLA = EmoggRenderTypes.createGlyphRT("emoji_no_texture_vanilla", class_293.class_5596.field_27379, class_4668.field_42517, class_4668.field_42518, null, false);
    public static final class_8538 EMOJI_LOADING = EmoggRenderTypes.createGlyphRT("emoji_loading", class_293.class_5596.field_27382, Shaders.EMOJI_LOADING, Shaders.EMOJI_LOADING_SEE_THROUGH, null, true);

    private static class_1921 setupEmojiRT(class_1921 renderType) {
        class_310.method_1551().method_22940().field_20957.put(renderType, new class_287(renderType.method_22722()));
        return renderType;
    }

    private static class_1921.class_4688.class_4689 beginStateWithShaderMaybeTexture(class_4668.class_5942 shader, @Nullable class_2960 texture) {
        class_1921.class_4688.class_4689 builder = class_1921.class_4688.method_23598();
        builder.method_34578(shader);
        builder.method_34577((class_4668.class_5939)(texture == null ? class_4668.field_21378 : new class_4668.class_4683(texture, true, false)));
        builder.method_23615(class_4668.field_21370);
        builder.method_23608(class_4668.field_21383);
        return builder;
    }

    private static class_1921 createRT(String name, class_293.class_5596 vertexMode, class_4668.class_5942 shader, @Nullable class_2960 texture, boolean needUV) {
        return EmoggRenderTypes.setupEmojiRT((class_1921)class_1921.method_24049((String)name, (class_293)(texture != null || needUV ? class_290.field_20888 : class_290.field_21468), (class_293.class_5596)vertexMode, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)EmoggRenderTypes.beginStateWithShaderMaybeTexture(shader, texture).method_23617(false)));
    }

    private static class_1921 createRTSeeThrough(String name, class_293.class_5596 vertexMode, class_4668.class_5942 shader, @Nullable class_2960 texture, boolean needUV) {
        return EmoggRenderTypes.setupEmojiRT((class_1921)class_1921.method_24049((String)(name + "_see_through"), (class_293)(texture != null || needUV ? class_290.field_20887 : class_290.field_1576), (class_293.class_5596)vertexMode, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)EmoggRenderTypes.beginStateWithShaderMaybeTexture(shader, texture).method_23604(class_4668.field_21346).method_23616(class_4668.field_21350).method_23617(false)));
    }

    private static class_1921 createRTPolygonOffset(String name, class_293.class_5596 vertexMode, class_4668.class_5942 shader, @Nullable class_2960 texture, boolean needUV) {
        return EmoggRenderTypes.setupEmojiRT((class_1921)class_1921.method_24049((String)(name + "_polygon_offset"), (class_293)(texture != null || needUV ? class_290.field_20888 : class_290.field_21468), (class_293.class_5596)vertexMode, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)EmoggRenderTypes.beginStateWithShaderMaybeTexture(shader, texture).method_23607(class_4668.field_21353).method_23617(false)));
    }

    private static class_8538 createGlyphRT(String name, class_293.class_5596 vertexMode, class_4668.class_5942 shader, class_4668.class_5942 seeThroughShader, @Nullable class_2960 texture, boolean needUV) {
        return new class_8538(EmoggRenderTypes.createRT(name, vertexMode, shader, texture, needUV), EmoggRenderTypes.createRTSeeThrough(name, vertexMode, seeThroughShader, texture, needUV), EmoggRenderTypes.createRTPolygonOffset(name, vertexMode, shader, texture, needUV));
    }

    private static boolean useCustomShaders() {
        return EmoggConfig.instance.enableCustomShaders && customShadersAvailable;
    }

    public static class_8538 emojiTextured(class_2960 texture) {
        if (EmoggRenderTypes.useCustomShaders()) {
            return EMOJI_TEXTURED.apply(texture);
        }
        return EMOJI_TEXTURED_VANILLA.apply(texture);
    }

    public static class_8538 emojiTexturedGrayscale(class_2960 texture) {
        if (EmoggRenderTypes.useCustomShaders()) {
            return EMOJI_TEXTURED_GRAYSCALE.apply(texture);
        }
        return EMOJI_TEXTURED_VANILLA.apply(texture);
    }

    public static class_8538 emojiNoTexture() {
        if (EmoggRenderTypes.useCustomShaders()) {
            return EMOJI_NO_TEXTURE;
        }
        return EMOJI_NO_TEXTURE_VANILLA;
    }

    public static class_8538 emojiLoading() {
        if (EmoggRenderTypes.useCustomShaders()) {
            return EMOJI_LOADING;
        }
        return EMOJI_NO_TEXTURE_VANILLA;
    }

    public static class Shaders {
        @Nullable
        private static class_5944 emojiTextured;
        @Nullable
        private static class_5944 emojiTexturedSeeThrough;
        @Nullable
        private static class_5944 emojiNoTexture;
        @Nullable
        private static class_5944 emojiNoTextureSeeThrough;
        @Nullable
        private static class_5944 emojiLoading;
        @Nullable
        private static class_5944 emojiLoadingSeeThrough;
        private static final class_4668.class_5942 EMOJI_TEXTURED;
        private static final class_4668.class_5942 EMOJI_TEXTURED_SEE_THROUGH;
        private static final class_4668.class_5942 EMOJI_TEXTURED_GRAYSCALE;
        private static final class_4668.class_5942 EMOJI_TEXTURED_GRAYSCALE_SEE_THROUGH;
        private static final class_4668.class_5942 EMOJI_NO_TEXTURE;
        private static final class_4668.class_5942 EMOJI_NO_TEXTURE_SEE_THROUGH;
        private static final class_4668.class_5942 EMOJI_LOADING;
        private static final class_4668.class_5942 EMOJI_LOADING_SEE_THROUGH;

        private static void _loadShaders(class_5912 resourceProvider, List<Pair<class_5944, Consumer<class_5944>>> list) throws IOException {
            String NAMESPACE = "emogg:";
            list.add((Pair<class_5944, Consumer<class_5944>>)Pair.of((Object)new class_5944(resourceProvider, "emogg:emoji_textured", class_290.field_20888), shader -> {
                emojiTextured = shader;
                Uniform.grayscaleModeIntensity.uniforms[0] = shader.method_35785("grayscale");
            }));
            list.add((Pair<class_5944, Consumer<class_5944>>)Pair.of((Object)new class_5944(resourceProvider, "emogg:emoji_textured_see_through", class_290.field_20887), shader -> {
                emojiTexturedSeeThrough = shader;
                Uniform.grayscaleModeIntensity.uniforms[1] = shader.method_35785("grayscale");
            }));
            list.add((Pair<class_5944, Consumer<class_5944>>)Pair.of((Object)new class_5944(resourceProvider, "emogg:emoji_no_texture", class_290.field_21468), shader -> {
                emojiNoTexture = shader;
            }));
            list.add((Pair<class_5944, Consumer<class_5944>>)Pair.of((Object)new class_5944(resourceProvider, "emogg:emoji_no_texture_see_through", class_290.field_1576), shader -> {
                emojiNoTextureSeeThrough = shader;
            }));
            list.add((Pair<class_5944, Consumer<class_5944>>)Pair.of((Object)new class_5944(resourceProvider, "emogg:emoji_loading", class_290.field_20888), shader -> {
                emojiLoading = shader;
                Uniform.loadingAnimationTime.uniforms[0] = shader.method_35785("animationTime");
            }));
            list.add((Pair<class_5944, Consumer<class_5944>>)Pair.of((Object)new class_5944(resourceProvider, "emogg:emoji_loading_see_through", class_290.field_20887), shader -> {
                emojiLoadingSeeThrough = shader;
                Uniform.loadingAnimationTime.uniforms[1] = shader.method_35785("animationTime");
            }));
        }

        public static void loadShaders(class_5912 resourceProvider, List<Pair<class_5944, Consumer<class_5944>>> list) {
            customShadersAvailable = false;
            Emogg.LOGGER.info("Loading emogg shaders...");
            try {
                Shaders._loadShaders(resourceProvider, list);
                customShadersAvailable = true;
            }
            catch (Exception e) {
                Emogg.LOGGER.error("Emogg shaders loading failed!", (Throwable)e);
            }
        }

        static {
            EMOJI_TEXTURED = new class_4668.class_5942(() -> {
                Uniform.grayscaleModeIntensity.method_1251(0.0f);
                return emojiTextured;
            });
            EMOJI_TEXTURED_SEE_THROUGH = new class_4668.class_5942(() -> {
                Uniform.grayscaleModeIntensity.method_1251(0.0f);
                return emojiTexturedSeeThrough;
            });
            EMOJI_TEXTURED_GRAYSCALE = new class_4668.class_5942(() -> {
                Uniform.grayscaleModeIntensity.method_1251(1.0f);
                return emojiTextured;
            });
            EMOJI_TEXTURED_GRAYSCALE_SEE_THROUGH = new class_4668.class_5942(() -> {
                Uniform.grayscaleModeIntensity.method_1251(1.0f);
                return emojiTexturedSeeThrough;
            });
            EMOJI_NO_TEXTURE = new class_4668.class_5942(() -> emojiNoTexture);
            EMOJI_NO_TEXTURE_SEE_THROUGH = new class_4668.class_5942(() -> emojiNoTextureSeeThrough);
            EMOJI_LOADING = new class_4668.class_5942(() -> emojiLoading);
            EMOJI_LOADING_SEE_THROUGH = new class_4668.class_5942(() -> emojiLoadingSeeThrough);
        }

        public static class Uniform {
            public static MultiUniform loadingAnimationTime = new MultiUniform(2);
            public static MultiUniform grayscaleModeIntensity = new MultiUniform(2);
        }
    }
}

