/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.emogg;

import io.github.aratakileo.elegantia.gui.config.Config;
import io.github.aratakileo.elegantia.updatechecker.ModrinthUpdateChecker;
import io.github.aratakileo.elegantia.updatechecker.Response;
import io.github.aratakileo.elegantia.updatechecker.ResponseCode;
import io.github.aratakileo.elegantia.util.ModInfo;
import io.github.aratakileo.elegantia.util.Platform;
import io.github.aratakileo.elegantia.util.ResourcePacksProvider;
import io.github.aratakileo.elegantia.util.Versions;
import io.github.aratakileo.emogg.EmoggConfig;
import io.github.aratakileo.emogg.emoji.Emoji;
import io.github.aratakileo.emogg.emoji.EmojiManager;
import io.github.aratakileo.emogg.gui.EmojiSuggestion;
import io.github.aratakileo.suggestionsapi.SuggestionsAPI;
import io.github.aratakileo.suggestionsapi.injector.Injector;
import io.github.aratakileo.suggestionsapi.util.Cast;
import java.util.LinkedList;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Emogg
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger(Emogg.class);
    public static final String NAMESPACE_OR_ID = "emogg";
    public static final ModrinthUpdateChecker UPDATE_CHECKER = new ModrinthUpdateChecker("emogg");

    public void onInitializeClient() {
        Response lastResponse = UPDATE_CHECKER.check();
        ModInfo modInfo = (ModInfo)ModInfo.get((String)NAMESPACE_OR_ID).orElseThrow();
        SuggestionsAPI.registerInjector((Injector)Injector.simple((Pattern)Pattern.compile("[:\uff1a][A-Za-z0-9_]*[:\uff1a]?$"), (currentExpression, startOffset) -> {
            LinkedList suggestions = new LinkedList();
            EmojiManager.getInstance().getEmojisStream().forEach(emoji -> {
                suggestions.add(new EmojiSuggestion((Emoji)emoji, ":%s:".formatted(emoji.getName())));
                suggestions.add(new EmojiSuggestion((Emoji)emoji, "\uff1a%s\uff1a".formatted(emoji.getName())));
            });
            return Cast.of(suggestions);
        }));
        LOGGER.info("emogg kernel platform: {}, loading platform: {}", (Object)modInfo.getKernelPlatform(), (Object)Platform.getCurrent());
        Object[] objectArray = new Object[3];
        objectArray[0] = Versions.getVersionKernel((String)modInfo.getVersion()).orElse("-invalid");
        objectArray[1] = switch (lastResponse.responseCode) {
            case ResponseCode.SUCCESSFUL, ResponseCode.NEW_VERSION_IS_AVAILABLE -> "available";
            default -> "not available";
        };
        objectArray[2] = switch (lastResponse.responseCode) {
            case ResponseCode.NO_VERSIONS_FOUND -> ", because does not exist for Minecraft v" + Platform.getMinecraftVersion();
            case ResponseCode.SUCCESSFUL, ResponseCode.NEW_VERSION_IS_AVAILABLE -> " v%s - %s".formatted(UPDATE_CHECKER.getLastResponseAsSuccessful().flatMap(response -> Versions.getVersionKernel((String)response.getDefinedVersion())).orElse("-unknown"), lastResponse.isNewVersionAvailable() ? "needs to be updated" : "not needs to be updated");
            case ResponseCode.DOES_NOT_EXIST_AT_MODRINTH -> ", because no longer available on modrinth";
            default -> ", because something went wrong";
        };
        LOGGER.info("[emogg] Installed v{}; {} to download (from modrinth.com){}", objectArray);
        if (lastResponse.isNoVersionsFound()) {
            LOGGER.warn("[emogg] It looks like you are using an unofficial version port!");
        }
        EmoggConfig.instance = (EmoggConfig)Config.init(EmoggConfig.class, (String)NAMESPACE_OR_ID);
        EmojiManager.init();
        this.registerBuiltinResourcePack("builtin");
        this.registerBuiltinResourcePack("twemogg");
    }

    private void registerBuiltinResourcePack(@NotNull String name) {
        ResourcePacksProvider.defineBuiltin((String)NAMESPACE_OR_ID, (String)name).setAutoCompatibilityCompliance(true).register();
    }
}

