/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.taint.incompats;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.fabricmc.loader.impl.gui.FabricGuiEntry;
import net.fabricmc.loader.impl.gui.FabricStatusTree;

public class SupersededModDetector
implements PreLaunchEntrypoint {
    private static final List<SupersededMod> POSSIBLE_MODS = ImmutableList.of((Object)new SupersededMod("sodium", "me/jellysquid/mods/sodium/client/SodiumClientMod.class"), (Object)new SupersededMod("indium", "link/infra/indium/Indium.class"));

    public void onPreLaunch() {
        List<String> supersededMods = this.getSupersededModFiles();
        if (supersededMods.isEmpty()) {
            return;
        }
        FabricGuiEntry.displayError((String)"Incompatible mods!", null, tree -> {
            FabricStatusTree.FabricStatusTab crashTab = tree.addTab("Error");
            crashTab.node.addMessage("Embeddium found one or mods installed that it replaces. These other mods should be removed:", FabricStatusTree.FabricTreeWarningLevel.ERROR);
            supersededMods.forEach(name -> crashTab.node.addMessage(name, FabricStatusTree.FabricTreeWarningLevel.ERROR));
            tree.tabs.removeIf(tab -> tab != crashTab);
        }, (boolean)true);
    }

    private List<String> getSupersededModFiles() {
        List<String> list;
        block8: {
            Path modsFolder = FabricLoader.getInstance().getGameDir().resolve("mods");
            Stream<Path> modFileStream = Files.find(modsFolder, 1, (p, a) -> a.isRegularFile() && p.getFileName().toString().endsWith(".jar"), new FileVisitOption[0]);
            try {
                list = modFileStream.filter(path -> {
                    try (ZipFile zf2 = new ZipFile(path.toFile());){
                        ZipEntry modJson = zf2.getEntry("fabric.mod.json");
                        if (modJson == null) {
                            boolean bl = false;
                            return bl;
                        }
                        JsonElement rootElement = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader(zf2.getInputStream(modJson))));
                        if (!rootElement.isJsonObject()) {
                            boolean bl = false;
                            return bl;
                        }
                        JsonPrimitive idP = ((JsonObject)rootElement).getAsJsonPrimitive("id");
                        if (!idP.isString()) {
                            boolean bl = false;
                            return bl;
                        }
                        String id = idP.getAsString();
                        Iterator<SupersededMod> iterator = POSSIBLE_MODS.iterator();
                        while (iterator.hasNext()) {
                            SupersededMod candidate = iterator.next();
                            if (!candidate.modId.equals(id)) continue;
                            if (zf2.getEntry(candidate.potentialClass) != null) {
                                boolean bl = true;
                                return bl;
                            }
                            System.err.println("Hmm, found mod file claiming to be " + candidate.modId + " but it is missing class");
                        }
                        return false;
                    }
                    catch (JsonParseException | ZipException zf2) {
                        return false;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return false;
                }).map(p -> p.getFileName().toString()).collect(Collectors.toList());
                if (modFileStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (modFileStream != null) {
                        try {
                            modFileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return List.of();
                }
            }
            modFileStream.close();
        }
        return list;
    }

    private record SupersededMod(String modId, String potentialClass) {
    }
}

