/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.taint.incompats;

import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import org.jetbrains.annotations.Nullable;

public interface ModDeclaration {
    public boolean matches();

    public static class And
    implements ModDeclaration {
        private final ModDeclaration left;
        private final ModDeclaration right;

        public And(ModDeclaration left, ModDeclaration right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean matches() {
            return this.left.matches() && this.right.matches();
        }

        public String toString() {
            return this.left.toString() + " and " + this.right.toString();
        }
    }

    public static class Or
    implements ModDeclaration {
        private final ModDeclaration left;
        private final ModDeclaration right;

        public Or(ModDeclaration left, ModDeclaration right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean matches() {
            return this.left.matches() || this.right.matches();
        }

        public String toString() {
            return this.left.toString() + " or " + this.right.toString();
        }
    }

    public static class Single
    implements ModDeclaration {
        private final String modId;
        private final String friendlyName;
        private final Version versionRange;

        public Single(String modId, String friendlyName) {
            this(modId, friendlyName, null);
        }

        public Single(String modId, String friendlyName, @Nullable String versionRange) {
            this.modId = modId;
            this.friendlyName = friendlyName;
            try {
                this.versionRange = null;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public boolean matches() {
            Optional modContainerOpt = FabricLoader.getInstance().getModContainer(this.modId);
            if (!modContainerOpt.isPresent()) {
                return false;
            }
            throw new UnsupportedOperationException("TODO port");
        }

        public String toString() {
            if (this.versionRange == null) {
                return this.friendlyName;
            }
            return this.friendlyName + "(" + this.versionRange + ")";
        }
    }
}

