/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.workarounds.context_creation;

import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.compatibility.checks.LateDriverScanner;
import me.jellysquid.mods.sodium.client.compatibility.checks.ModuleScanner;
import me.jellysquid.mods.sodium.client.compatibility.workarounds.Workarounds;
import me.jellysquid.mods.sodium.client.compatibility.workarounds.nvidia.NvidiaWorkarounds;
import net.minecraft.class_1041;
import net.minecraft.class_156;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.WGL;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1041.class})
public class WindowMixin {
    @Shadow
    @Final
    private static Logger field_5178;
    @Unique
    private long wglPrevContext = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwCreateWindow(IILjava/lang/CharSequence;JJ)J", remap=false))
    private long wrapGlfwCreateWindow(int width, int height, CharSequence title, long monitor, long share) {
        boolean applyNvidiaWorkarounds = Workarounds.isWorkaroundEnabled(Workarounds.Reference.NVIDIA_THREADED_OPTIMIZATIONS);
        if (applyNvidiaWorkarounds) {
            NvidiaWorkarounds.install();
        }
        if (SodiumClientMod.options().performance.useNoErrorGLContext && !Workarounds.isWorkaroundEnabled(Workarounds.Reference.NO_ERROR_CONTEXT_UNSUPPORTED)) {
            GLFW.glfwWindowHint((int)139274, (int)1);
        }
        try {
            long l = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)title, (long)monitor, (long)share);
            return l;
        }
        finally {
            if (applyNvidiaWorkarounds) {
                NvidiaWorkarounds.uninstall();
            }
        }
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL;createCapabilities()Lorg/lwjgl/opengl/GLCapabilities;", remap=false, shift=At.Shift.AFTER)})
    private void postWindowCreated(CallbackInfo ci) {
        this.wglPrevContext = class_156.method_668() == class_156.class_158.field_1133 ? WGL.wglGetCurrentContext() : 0L;
        LateDriverScanner.onContextInitialized();
        ModuleScanner.checkModules();
    }

    @Inject(method={"updateDisplay"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;flipFrame(J)V", remap=false, shift=At.Shift.AFTER)})
    private void preSwapBuffers(CallbackInfo ci) {
        if (this.wglPrevContext == 0L) {
            return;
        }
        long context = WGL.wglGetCurrentContext();
        if (this.wglPrevContext == context) {
            return;
        }
        field_5178.warn("The OpenGL context appears to have been suddenly replaced! Something has likely just injected into the game process.");
        ModuleScanner.checkModules();
        this.wglPrevContext = context;
    }
}

