/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.mixin.MixinClassValidator;
import me.jellysquid.mods.sodium.mixin.MixinConfig;
import me.jellysquid.mods.sodium.mixin.MixinOption;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.embeddedt.embeddium.config.ConfigMigrator;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class SodiumMixinPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PACKAGE_ROOT = "me.jellysquid.mods.sodium.mixin.";
    private final Logger logger = LogManager.getLogger((String)"Embeddium");
    private MixinConfig config;

    public void onLoad(String mixinPackage) {
        try {
            this.config = MixinConfig.load(ConfigMigrator.handleConfigMigration("embeddium-mixins.properties").toFile());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load configuration file for Embeddium", e);
        }
        this.logger.info("Loaded configuration file for Embeddium: {} options available, {} override(s) found", (Object)this.config.getOptionCount(), (Object)this.config.getOptionOverrideCount());
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String s, String s1) {
        return true;
    }

    private boolean isMixinEnabled(String mixin) {
        MixinOption option = this.config.getEffectiveOptionForMixin(mixin);
        if (option == null) {
            if (!mixin.startsWith("modcompat.")) {
                this.logger.error("No rules matched mixin '{}', treating as foreign and disabling!", (Object)mixin);
            }
            return false;
        }
        if (option.isOverridden()) {
            Object source = "[unknown]";
            if (option.isUserDefined()) {
                source = "user configuration";
            } else if (option.isModDefined()) {
                source = "mods [" + String.join((CharSequence)", ", option.getDefiningMods()) + "]";
            }
            if (option.isEnabled()) {
                this.logger.warn("Force-enabling mixin '{}' as rule '{}' (added by {}) enables it", (Object)mixin, (Object)option.getName(), source);
            } else {
                this.logger.warn("Force-disabling mixin '{}' as rule '{}' (added by {}) disables it and children", (Object)mixin, (Object)option.getName(), source);
            }
        }
        return option.isEnabled();
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    private static String mixinClassify(Path baseFolder, Path path) {
        try {
            String className = baseFolder.relativize(path).toString().replace('/', '.');
            return className.substring(0, className.length() - 6);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Error relativizing " + path + " to " + baseFolder, e);
        }
    }

    private static Path findPathInMod(ModContainer modFile, String ... pathComponents) {
        return modFile.findPath(String.join((CharSequence)"/", pathComponents)).orElse(null);
    }

    public List<String> getMixins() {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return null;
        }
        Optional modFileOpt = FabricLoader.getInstance().getModContainer("embeddium");
        if (modFileOpt.isEmpty()) {
            this.logger.error("Could not find embeddium mod, there is likely a dependency error. Skipping mixin application.");
            return null;
        }
        ModContainer modFile = (ModContainer)modFileOpt.get();
        HashSet<Path> rootPaths = new HashSet<Path>();
        for (String basePackage : new String[]{"core", "modcompat"}) {
            Path mixinPackagePath = SodiumMixinPlugin.findPathInMod(modFile, "me", "jellysquid", "mods", "sodium", "mixin", basePackage);
            if (mixinPackagePath == null || !Files.exists(mixinPackagePath, new LinkOption[0])) continue;
            rootPaths.add(mixinPackagePath.getParent().toAbsolutePath());
        }
        HashSet possibleMixinClasses = new HashSet();
        for (Path rootPath : rootPaths) {
            try {
                Stream<Path> mixinStream = Files.find(rootPath, Integer.MAX_VALUE, (path, attrs) -> attrs.isRegularFile() && path.getFileName().toString().endsWith(".class"), new FileVisitOption[0]);
                try {
                    mixinStream.map(Path::toAbsolutePath).filter(MixinClassValidator::isMixinClass).map(path -> SodiumMixinPlugin.mixinClassify(rootPath, path)).filter(this::isMixinEnabled).forEach(possibleMixinClasses::add);
                }
                finally {
                    if (mixinStream == null) continue;
                    mixinStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new ArrayList<String>(possibleMixinClasses);
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

