/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.cloned;

import it.unimi.dsi.fastutil.longs.Long2ReferenceLinkedOpenHashMap;
import java.util.concurrent.TimeUnit;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSection;
import net.minecraft.class_1937;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClonedChunkSectionCache {
    private static final int MAX_CACHE_SIZE = 512;
    private static final long MAX_CACHE_DURATION = TimeUnit.SECONDS.toNanos(5L);
    private final class_1937 world;
    private final Long2ReferenceLinkedOpenHashMap<ClonedChunkSection> positionToEntry = new Long2ReferenceLinkedOpenHashMap();
    private long time;

    public ClonedChunkSectionCache(class_1937 world) {
        this.world = world;
        this.time = ClonedChunkSectionCache.getMonotonicTimeSource();
    }

    public synchronized void cleanup() {
        this.time = ClonedChunkSectionCache.getMonotonicTimeSource();
        this.positionToEntry.values().removeIf(entry -> this.time > entry.getLastUsedTimestamp() + MAX_CACHE_DURATION);
    }

    @Nullable
    public synchronized ClonedChunkSection acquire(int x, int y, int z) {
        long pos = class_4076.method_18685((int)x, (int)y, (int)z);
        ClonedChunkSection section = (ClonedChunkSection)this.positionToEntry.getAndMoveToLast(pos);
        if (section == null) {
            section = this.clone(x, y, z);
            while (this.positionToEntry.size() >= 512) {
                this.positionToEntry.removeFirst();
            }
            this.positionToEntry.putAndMoveToLast(pos, (Object)section);
        }
        section.setLastUsedTimestamp(this.time);
        return section;
    }

    @NotNull
    private ClonedChunkSection clone(int x, int y, int z) {
        class_2818 chunk = this.world.method_8497(x, z);
        if (chunk == null) {
            throw new RuntimeException("Chunk is not loaded at: " + class_4076.method_18685((int)x, (int)y, (int)z));
        }
        class_2826 section = null;
        if (!this.world.method_31601(class_4076.method_18688((int)y))) {
            section = chunk.method_12006()[this.world.method_31603(y)];
        }
        return new ClonedChunkSection(this.world, chunk, section, class_4076.method_18676((int)x, (int)y, (int)z));
    }

    public synchronized void invalidate(int x, int y, int z) {
        this.positionToEntry.remove(class_4076.method_18685((int)x, (int)y, (int)z));
    }

    private static long getMonotonicTimeSource() {
        return System.nanoTime();
    }
}

