/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import me.jellysquid.mods.sodium.client.compat.ccl.SinkingVertexBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockOcclusionCache;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.material.Material;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2350;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public class IndigoBlockRenderContext
extends net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderContext {
    private final Map<class_1921, SinkingVertexBuilder> vertexBuilderMap = new Object2ObjectOpenHashMap();
    private BlockRenderContext currentContext;
    private final BlockOcclusionCache occlusionCache;
    private int cullChecked;
    private int cullValue;

    public IndigoBlockRenderContext(BlockOcclusionCache occlusionCache) {
        this.occlusionCache = occlusionCache;
    }

    public boolean isFaceCulled(@Nullable class_2350 face) {
        boolean flag;
        if (face == null) {
            return false;
        }
        int fM = 1 << face.ordinal();
        if ((this.cullChecked & fM) != 0) {
            return (this.cullValue & fM) != 0;
        }
        BlockRenderContext ctx = this.currentContext;
        boolean bl = flag = !this.occlusionCache.shouldDrawSide(ctx.state(), (class_1922)ctx.localSlice(), ctx.pos(), face);
        if (flag) {
            this.cullValue |= fM;
        }
        this.cullChecked |= fM;
        return flag;
    }

    protected class_4588 getVertexConsumer(class_1921 layer) {
        return this.vertexBuilderMap.computeIfAbsent(layer, k -> new SinkingVertexBuilder());
    }

    public void reset() {
        this.vertexBuilderMap.values().forEach(SinkingVertexBuilder::reset);
        this.cullChecked = 0;
        this.cullValue = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderEmbeddium(BlockRenderContext ctx, class_4587 mStack, class_5819 random) {
        this.currentContext = ctx;
        try {
            this.render(ctx.localSlice(), ctx.model(), ctx.state(), ctx.pos(), mStack, null, true, random, ctx.seed(), class_4608.field_21444);
        }
        finally {
            this.currentContext = null;
        }
    }

    public void flush(ChunkBuildBuffers buffers, Vector3fc origin) {
        this.vertexBuilderMap.forEach((renderType, sinkingVertexBuilder) -> {
            if (sinkingVertexBuilder.isEmpty()) {
                return;
            }
            Material material = DefaultMaterials.forRenderLayer(renderType);
            ChunkModelBuilder builder = buffers.get(material);
            sinkingVertexBuilder.flush(builder, material, origin);
        });
    }
}

