/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.quirks;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import net.fabricmc.loader.api.FabricLoader;

public class QuirkManager {
    public static final boolean REBIND_LIGHTMAP_TEXTURE = Stream.of("quartz", "lodestone").allMatch(QuirkManager::isLoaded);

    private static boolean isLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    static {
        try {
            ArrayList<String> enabledQuirks = new ArrayList<String>();
            for (Field f : QuirkManager.class.getDeclaredFields()) {
                if (f.getType() != Boolean.TYPE || !Modifier.isStatic(f.getModifiers()) || !f.getBoolean(null)) continue;
                enabledQuirks.add(f.getName());
            }
            if (enabledQuirks.size() > 0) {
                SodiumClientMod.logger().warn("Enabled the following quirks in QuirkManager: [{}]", (Object)String.join((CharSequence)", ", enabledQuirks));
            }
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }
}

