/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.quad.blender;

import java.util.Arrays;
import me.jellysquid.mods.sodium.client.model.color.ColorProvider;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public abstract class BlendedColorProvider<T>
implements ColorProvider<T> {
    private static boolean shouldUseVertexBlending;

    public static void checkBlendingEnabled() {
        shouldUseVertexBlending = (Integer)class_310.method_1551().field_1690.method_41805().method_41753() > 0;
    }

    @Override
    public void getColors(WorldSlice view, class_2338 pos, T state, ModelQuadView quad, int[] output) {
        if (shouldUseVertexBlending) {
            for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                output[vertexIndex] = this.getVertexColor(view, pos, quad, vertexIndex);
            }
        } else {
            Arrays.fill(output, ColorARGB.toABGR(this.getColor(view, pos.method_10263(), pos.method_10264(), pos.method_10260())));
        }
    }

    private int getVertexColor(WorldSlice world, class_2338 blockPos, ModelQuadView quad, int vertexIndex) {
        float posX = quad.getX(vertexIndex) - 0.5f;
        float posY = quad.getY(vertexIndex) - 0.5f;
        float posZ = quad.getZ(vertexIndex) - 0.5f;
        int intX = class_3532.method_15375((float)posX);
        int intY = class_3532.method_15375((float)posY);
        int intZ = class_3532.method_15375((float)posZ);
        int worldIntX = blockPos.method_10263() + intX;
        int worldIntY = blockPos.method_10264() + intY;
        int worldIntZ = blockPos.method_10260() + intZ;
        int c00 = this.getColor(world, worldIntX + 0, worldIntY, worldIntZ + 0);
        int c01 = this.getColor(world, worldIntX + 0, worldIntY, worldIntZ + 1);
        int c10 = this.getColor(world, worldIntX + 1, worldIntY, worldIntZ + 0);
        int c11 = this.getColor(world, worldIntX + 1, worldIntY, worldIntZ + 1);
        int z0 = c00 != c01 ? ColorMixer.mix(c00, c01, posZ - (float)intZ) : c00;
        int z1 = c10 != c11 ? ColorMixer.mix(c10, c11, posZ - (float)intZ) : c10;
        int x0 = z0 != z1 ? ColorMixer.mix(z0, z1, posX - (float)intX) : z0;
        return ColorARGB.toABGR(x0);
    }

    protected abstract int getColor(WorldSlice var1, int var2, int var3, int var4);
}

