/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.data.fingerprint;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.util.FileUtil;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record HashedFingerprint(@SerializedName(value="v") int version, @SerializedName(value="s") @NotNull String saltHex, @SerializedName(value="u") @NotNull String uuidHashHex, @SerializedName(value="p") @NotNull String pathHashHex, @SerializedName(value="t") long timestamp) {
    public static final int CURRENT_VERSION = 1;

    @Nullable
    public static HashedFingerprint loadFromDisk() {
        HashedFingerprint data;
        Path path = HashedFingerprint.getFilePath();
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            data = (HashedFingerprint)new Gson().fromJson(Files.readString(path), HashedFingerprint.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load data file", e);
        }
        if (data.version() != 1) {
            return null;
        }
        return data;
    }

    public static void writeToDisk(@NotNull HashedFingerprint data) {
        Objects.requireNonNull(data);
        try {
            FileUtil.writeTextRobustly(new Gson().toJson((Object)data), HashedFingerprint.getFilePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save data file", e);
        }
    }

    private static Path getFilePath() {
        return FabricLoader.getInstance().getConfigDir().resolve("embeddium-fingerprint.json");
    }
}

