/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client;

import java.io.IOException;
import me.jellysquid.mods.sodium.client.data.fingerprint.FingerprintMeasure;
import me.jellysquid.mods.sodium.client.data.fingerprint.HashedFingerprint;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_3264;
import org.embeddedt.embeddium.render.ShaderModBridge;
import org.embeddedt.embeddium.render.frapi.SpriteFinderCache;
import org.embeddedt.embeddium.taint.scanning.TaintDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SodiumClientMod
implements ClientModInitializer {
    public static final String MODID = "embeddium";
    public static final String MODNAME = "Embeddium";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Embeddium");
    private static SodiumGameOptions CONFIG = SodiumClientMod.loadConfig();
    private static String MOD_VERSION;

    public void onInitializeClient() {
        MOD_VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer(MODID).get()).getMetadata().getVersion().toString();
        TaintDetector.init();
        try {
            SodiumClientMod.updateFingerprint();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to update fingerprint", t);
        }
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)SpriteFinderCache.ReloadListener.INSTANCE);
    }

    public static SodiumGameOptions options() {
        if (CONFIG == null) {
            throw new IllegalStateException("Config not yet available");
        }
        return CONFIG;
    }

    public static Logger logger() {
        if (LOGGER == null) {
            throw new IllegalStateException("Logger not yet available");
        }
        return LOGGER;
    }

    private static SodiumGameOptions loadConfig() {
        try {
            return SodiumGameOptions.load();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load configuration file", (Throwable)e);
            LOGGER.error("Using default configuration file in read-only mode");
            SodiumGameOptions config = new SodiumGameOptions();
            config.setReadOnly();
            return config;
        }
    }

    public static void restoreDefaultOptions() {
        CONFIG = SodiumGameOptions.defaults();
        try {
            CONFIG.writeChanges();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write config file", e);
        }
    }

    public static String getVersion() {
        if (MOD_VERSION == null) {
            throw new NullPointerException("Mod version hasn't been populated yet");
        }
        return MOD_VERSION;
    }

    private static void updateFingerprint() {
        FingerprintMeasure current = FingerprintMeasure.create();
        if (current == null) {
            return;
        }
        HashedFingerprint saved = null;
        try {
            saved = HashedFingerprint.loadFromDisk();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to load existing fingerprint", t);
        }
        if (saved == null || !current.looselyMatches(saved)) {
            HashedFingerprint.writeToDisk(current.hashed());
            SodiumClientMod.CONFIG.notifications.hasSeenDonationPrompt = false;
            SodiumClientMod.CONFIG.notifications.hasClearedDonationButton = false;
            try {
                CONFIG.writeChanges();
            }
            catch (IOException e) {
                LOGGER.error("Failed to update config file", (Throwable)e);
            }
        }
    }

    public static boolean canUseVanillaVertices() {
        return !SodiumClientMod.options().performance.useCompactVertexFormat && !ShaderModBridge.areShadersEnabled();
    }
}

