/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.util;

import java.lang.module.ModuleDescriptor;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Versions {
    private static final Pattern ONLY_NUMBER_PATTERN = Pattern.compile("^([a-zA-Z]+((\\d+\\.)+\\d+)?[-_]?)?(?<kernel>(\\d+\\.)+\\d+(-(?:alpha|beta|a|b)(?![a-zA-Z])(\\.\\d+)?)?)");

    private Versions() {
    }

    @NotNull
    public static Optional<String> getVersionKernel(@NotNull String version) {
        Matcher matcher = ONLY_NUMBER_PATTERN.matcher(version);
        return matcher.find() ? Optional.of(matcher.group("kernel")) : Optional.empty();
    }

    public static boolean isGreaterThan(@NotNull String leftVersion, @NotNull String rightVersion) {
        return ModuleDescriptor.Version.parse(rightVersion).compareTo(ModuleDescriptor.Version.parse(leftVersion)) >= 1;
    }
}

