/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.util;

import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public interface Strings {
    @NotNull
    public static String camelToSnake(@NotNull String value) {
        if (value.isEmpty()) {
            return value;
        }
        return Strings.separateCamelCase(value, '_');
    }

    @NotNull
    public static String separateCamelCase(@NotNull String value, char separator) {
        String replacementStatement = "$1" + separator + "$2";
        return value.replaceAll("([A-Z]+)([A-Z][a-z])", replacementStatement).replaceAll("([a-z])([A-Z])", replacementStatement).toLowerCase();
    }

    @NotNull
    public static String requireReturnNotAsArgument(@NotNull String argumentValue, @NotNull @NotNull Function<@NotNull String, @NotNull String> processor, @NotNull String elseValue) {
        String functionReturn = processor.apply(argumentValue);
        return functionReturn.equals(argumentValue) ? elseValue : functionReturn;
    }

    @NotNull
    public static String doesNotMeetCondition(@NotNull String ifValue, @NotNull @NotNull Function<@NotNull String, @NotNull Boolean> condition, @NotNull String elseValue) {
        return condition.apply(ifValue) == false ? ifValue : elseValue;
    }

    @NotNull
    public static String substring(@NotNull String source, @Range(from=0L, to=0x7FFFFFFFL) int beginIndex, @Range(from=-2147483648L, to=0x7FFFFFFFL) int endIndex) {
        if (endIndex == beginIndex) {
            return "";
        }
        if (endIndex < 0) {
            if (endIndex <= -source.length() + beginIndex) {
                return "";
            }
            return source.substring(beginIndex, source.length() - endIndex);
        }
        return source.substring(beginIndex, endIndex);
    }

    @NotNull
    public static String capitalize(@NotNull String source) {
        return StringUtils.capitalize((String)source);
    }

    @NotNull
    public static String repr(@NotNull String value) {
        StringBuilder stringBuilder = new StringBuilder("\"");
        for (char ch : value.toCharArray()) {
            if (ch == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (ch == '\"' || ch == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(ch);
        }
        return stringBuilder.append('\"').toString();
    }
}

