/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.util;

import io.github.aratakileo.elegantia.util.ModInfo;
import io.github.aratakileo.elegantia.util.Platform;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourcePacksProvider {
    private static final HashMap<String, class_3288> CLIENT_RESOURCE_PACKS = new HashMap();
    private static final HashMap<String, class_3288> SERVER_RESOURCE_PACKS = new HashMap();
    private static final ArrayList<String> DEFAULT_ENABLED_RESOURCE_PACK_NAMES = new ArrayList();
    private final class_2960 packLocation;
    private boolean autoCompatibilityCompliance = false;
    private boolean isDefaultEnabled = true;
    @NotNull
    private String packsDirPath = "resourcepacks";
    @Nullable
    private class_2561 displayName = null;

    private ResourcePacksProvider(@NotNull class_2960 packLocation) {
        ModInfo.throwIfModIsNotLoaded(packLocation.method_12836());
        this.packLocation = packLocation;
    }

    @NotNull
    public static ResourcePacksProvider defineBuiltin(@NotNull class_2960 resourceLocation) {
        return new ResourcePacksProvider(resourceLocation);
    }

    @NotNull
    public static ResourcePacksProvider defineBuiltin(@NotNull String modId, @NotNull String packDirPath) {
        return new ResourcePacksProvider(new class_2960(modId, packDirPath));
    }

    @NotNull
    public ResourcePacksProvider setAutoCompatibilityCompliance(boolean autoCompatibilityCompliance) {
        this.autoCompatibilityCompliance = autoCompatibilityCompliance;
        return this;
    }

    @NotNull
    public ResourcePacksProvider setDefaultEnabled(boolean defaultEnabled) {
        this.isDefaultEnabled = defaultEnabled;
        return this;
    }

    @NotNull
    public ResourcePacksProvider setPacksDirPath(@NotNull String packsDirPath) {
        this.packsDirPath = packsDirPath;
        return this;
    }

    @NotNull
    public ResourcePacksProvider setDisplayName(@NotNull class_2561 displayName) {
        this.displayName = displayName;
        return this;
    }

    public boolean register() {
        boolean result;
        Optional<Path> optionalResourcePacksPath = ModInfo.findPath(this.packLocation.method_12836(), this.packsDirPath);
        if (optionalResourcePacksPath.isEmpty()) {
            return false;
        }
        Path resourcePackPath = optionalResourcePacksPath.get().resolve(this.packLocation.method_12832()).toAbsolutePath().normalize();
        if (!Files.exists(resourcePackPath, new LinkOption[0])) {
            return false;
        }
        String name = this.packLocation.toString();
        class_2561 finishedDisplayName = Objects.nonNull(this.displayName) ? this.displayName : class_2561.method_43471((String)"%s.resourcepack.%s.title".formatted(this.packLocation.method_12836(), this.packLocation.method_12832().replaceAll("[/\\\\]+", ".")));
        boolean bl = result = Platform.getEnvironment().isClient() && ResourcePacksProvider.registerBuiltin(class_3264.field_14188, name, finishedDisplayName, resourcePackPath, this.autoCompatibilityCompliance);
        if ((result |= ResourcePacksProvider.registerBuiltin(class_3264.field_14190, name, finishedDisplayName, resourcePackPath, this.autoCompatibilityCompliance)) && this.isDefaultEnabled) {
            DEFAULT_ENABLED_RESOURCE_PACK_NAMES.add(name);
        }
        return result;
    }

    public static void consumeBuiltinPacks(@NotNull class_3264 type, Consumer<class_3288> packConsumer) {
        HashMap<String, class_3288> builtinPacks = type == class_3264.field_14188 ? CLIENT_RESOURCE_PACKS : SERVER_RESOURCE_PACKS;
        builtinPacks.values().forEach(packConsumer);
    }

    @NotNull
    public static List<String> getDefaultEnabledResourcePackNames() {
        return DEFAULT_ENABLED_RESOURCE_PACK_NAMES;
    }

    private static boolean registerBuiltin(@NotNull class_3264 packType, @NotNull String name, @NotNull class_2561 displayName, @NotNull Path resourcePackPath, boolean autoCompatibilityCompliance) {
        class_3288 pack = ResourcePacksProvider.createBuiltinPack(packType, name, path -> new class_3259(path, resourcePackPath, false), displayName, autoCompatibilityCompliance);
        if (Objects.isNull(pack)) {
            return false;
        }
        if (packType == class_3264.field_14188) {
            CLIENT_RESOURCE_PACKS.put(pack.method_14463(), pack);
        } else {
            SERVER_RESOURCE_PACKS.put(pack.method_14463(), pack);
        }
        return true;
    }

    @Nullable
    private static class_3288 createBuiltinPack(@NotNull class_3264 packType, @NotNull String name, @NotNull class_3288.class_7680 resourcesSupplier, @NotNull class_2561 displayName, boolean autoCompatibilityCompliance) {
        class_3288.class_7679 info = class_3288.method_45274((String)name, (class_3288.class_7680)resourcesSupplier);
        if (Objects.isNull(info)) {
            return null;
        }
        if (autoCompatibilityCompliance) {
            info = new class_3288.class_7679(info.comp_999(), class_155.method_16673().method_48017(packType), info.comp_1001());
        }
        return class_3288.method_14456((String)name, (class_2561)displayName, (boolean)false, (class_3288.class_7680)resourcesSupplier, (class_3288.class_7679)info, (class_3264)packType, (class_3288.class_3289)class_3288.class_3289.field_14280, (boolean)false, (class_5352)class_5352.field_25348);
    }
}

