/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.util;

import com.terraformersmc.modmenu.ModMenu;
import io.github.aratakileo.elegantia.Elegantia;
import io.github.aratakileo.elegantia.exception.NoSuchModException;
import io.github.aratakileo.elegantia.util.Platform;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

public abstract class ModInfo {
    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getVersion();

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getDescription();

    @NotNull
    public abstract Collection<String> getAuthors();

    @NotNull
    public abstract Collection<String> getContributors();

    @NotNull
    public abstract Optional<Map<String, String>> getUrls();

    @NotNull
    public abstract Environment getEnvironment();

    @NotNull
    public abstract List<Path> getRootPaths();

    @NotNull
    public Optional<Path> findPath(@NotNull String relativePath) {
        for (Path rootPath : this.getRootPaths()) {
            Path path = rootPath.resolve(relativePath.replace("/", rootPath.getFileSystem().getSeparator()));
            if (!Files.exists(path, new LinkOption[0])) continue;
            return Optional.of(path);
        }
        return Optional.empty();
    }

    @NotNull
    public Optional<String> getUrl(@NotNull String key) {
        return this.getUrls().map(map -> (String)map.get(key));
    }

    @NotNull
    public Optional<String> getSourcesUrl() {
        return this.getUrl("sources");
    }

    @NotNull
    public Optional<String> getIssuesUrl() {
        return this.getUrl("issues");
    }

    @NotNull
    public Optional<String> getHomepageUrl() {
        return this.getUrl("homepage");
    }

    @NotNull
    public Platform getKernelPlatform() {
        if (this.findPath("fabric.mod.json").map(x$0 -> Files.exists(x$0, new LinkOption[0])).orElse(false).booleanValue()) {
            return Platform.FABRIC;
        }
        if (this.findPath("quilt.mod.json").map(x$0 -> Files.exists(x$0, new LinkOption[0])).orElse(false).booleanValue()) {
            return Platform.QUILT;
        }
        return Platform.FORGE;
    }

    public void setConfigScreenGetter(@NotNull Function<class_437, class_437> configScreenGetter) {
        if (!ModInfo.isModLoaded("modmenu")) {
            return;
        }
        if (ModInfo.isModLoaded("connectormod") && !ModInfo.isModLoaded("fabric_api") || ModInfo.isModLoaded("connectorextras")) {
            return;
        }
        try {
            Field field = ModMenu.class.getDeclaredField("configScreenFactories");
            field.setAccessible(true);
            Map configScreenFactories = (Map)field.get(null);
            configScreenFactories.put(this.getId(), configScreenGetter::apply);
            field.set(null, configScreenFactories);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Elegantia.LOGGER.error("Something went wrong while trying to set config screen getter for mod id `" + this.getId() + "`", (Throwable)e);
        }
    }

    @NotNull
    public static Optional<ModInfo> get(@NotNull String modId) {
        final ModContainer modContainer = FabricLoader.getInstance().getModContainer(modId).orElse(null);
        if (Objects.isNull(modContainer)) {
            return Optional.empty();
        }
        final ModMetadata modMetadata = modContainer.getMetadata();
        return Optional.of(new ModInfo(){

            @Override
            @NotNull
            public String getId() {
                return modMetadata.getId();
            }

            @Override
            @NotNull
            public String getVersion() {
                return modMetadata.getVersion().getFriendlyString();
            }

            @Override
            @NotNull
            public String getName() {
                return modMetadata.getName();
            }

            @Override
            @NotNull
            public String getDescription() {
                return modMetadata.getDescription();
            }

            @Override
            @NotNull
            public Collection<String> getAuthors() {
                return modMetadata.getAuthors().stream().map(Person::getName).toList();
            }

            @Override
            @NotNull
            public Collection<String> getContributors() {
                return modMetadata.getContributors().stream().map(Person::getName).toList();
            }

            @Override
            @NotNull
            public Optional<Map<String, String>> getUrls() {
                return Optional.ofNullable(modMetadata.getContact().asMap());
            }

            @Override
            @NotNull
            public Environment getEnvironment() {
                return switch (modMetadata.getEnvironment()) {
                    default -> throw new IncompatibleClassChangeError();
                    case ModEnvironment.CLIENT -> Environment.CLIENT;
                    case ModEnvironment.SERVER -> Environment.SERVER;
                    case ModEnvironment.UNIVERSAL -> Environment.BOTH;
                };
            }

            @Override
            @NotNull
            public List<Path> getRootPaths() {
                return modContainer.getRootPaths();
            }
        });
    }

    @NotNull
    public static Optional<String> getVersion(@NotNull String modId) {
        return ModInfo.get(modId).map(ModInfo::getVersion);
    }

    @NotNull
    public static Optional<String> getName(@NotNull String modId) {
        return ModInfo.get(modId).map(ModInfo::getName);
    }

    @NotNull
    public static Optional<String> getDescription(@NotNull String modId) {
        return ModInfo.get(modId).map(ModInfo::getDescription);
    }

    @NotNull
    public static Optional<Collection<String>> getAuthors(@NotNull String modId) {
        return ModInfo.get(modId).map(ModInfo::getAuthors);
    }

    @NotNull
    public static Optional<Collection<String>> getContributors(@NotNull String modId) {
        return ModInfo.get(modId).map(ModInfo::getContributors);
    }

    @NotNull
    public static Optional<Map<String, String>> getUrls(@NotNull String modId) {
        return ModInfo.get(modId).flatMap(ModInfo::getUrls);
    }

    @NotNull
    public static Optional<List<Path>> getRootPaths(@NotNull String modId) {
        return ModInfo.get(modId).map(ModInfo::getRootPaths);
    }

    @NotNull
    public static Optional<Path> findPath(@NotNull String modId, @NotNull String relativePath) {
        return ModInfo.get(modId).flatMap(modInfo -> modInfo.findPath(relativePath));
    }

    @NotNull
    public static Optional<String> getUrl(@NotNull String modId, @NotNull String key) {
        return ModInfo.get(modId).flatMap(modInfo -> modInfo.getUrl(key));
    }

    @NotNull
    public static Optional<String> getSourcesUrl(@NotNull String modId) {
        return ModInfo.get(modId).flatMap(ModInfo::getSourcesUrl);
    }

    @NotNull
    public static Optional<String> getIssuesUrl(@NotNull String modId) {
        return ModInfo.get(modId).flatMap(ModInfo::getIssuesUrl);
    }

    @NotNull
    public static Optional<String> getHomepageUrl(@NotNull String modId) {
        return ModInfo.get(modId).flatMap(ModInfo::getHomepageUrl);
    }

    @NotNull
    public static Optional<Environment> getEnvironment(@NotNull String modId) {
        return ModInfo.get(modId).map(ModInfo::getEnvironment);
    }

    @NotNull
    public static Optional<Platform> getKernelPlatform(@NotNull String modId) {
        return ModInfo.get(modId).map(ModInfo::getKernelPlatform);
    }

    public static void setConfigScreenGetter(@NotNull String modId, @NotNull Function<class_437, class_437> configScreenGetter) {
        if (!ModInfo.isModLoaded("modmenu")) {
            return;
        }
        if (!ModInfo.isModLoaded(modId)) {
            Elegantia.LOGGER.error("Failed to set config screen getter for mod id `" + modId + "`, because mod does not exist");
            return;
        }
        ModInfo.get(modId).orElseThrow().setConfigScreenGetter(configScreenGetter);
    }

    public static boolean isModLoaded(@NotNull String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    public static void throwIfModIsNotLoaded(@NotNull String modId) {
        if (!ModInfo.isModLoaded(modId)) {
            throw new NoSuchModException("id=" + modId);
        }
    }

    public static enum Environment {
        CLIENT,
        SERVER,
        BOTH;

    }
}

