/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.util;

import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnyOfPair<Left, Right> {
    @Nullable
    public final Left leftValue;
    @Nullable
    public final Right rightValue;

    private AnyOfPair(@Nullable Left leftValue, @Nullable Right rightValue) {
        this.leftValue = leftValue;
        this.rightValue = rightValue;
    }

    public boolean isLeft() {
        return Objects.nonNull(this.leftValue);
    }

    public boolean isRight() {
        return Objects.nonNull(this.rightValue);
    }

    public <T> boolean is(@NotNull Class<? extends T> type) {
        return Objects.nonNull(this.leftValue) && this.leftValue.getClass() == type || Objects.nonNull(this.rightValue) && this.rightValue.getClass() == type;
    }

    public <T> void ifIs(@NotNull Class<? extends T> type, @NotNull @NotNull Consumer<@NotNull T> consumer) {
        if (!this.is(type)) {
            return;
        }
        T value = this.get(type);
        if (Objects.nonNull(value)) {
            consumer.accept(value);
        }
    }

    @Nullable
    public <T> T get(@NotNull Class<? extends T> type) {
        if (Objects.nonNull(this.leftValue) && this.leftValue.getClass() == type) {
            return (T)this.leftValue;
        }
        if (Objects.nonNull(this.rightValue) && this.rightValue.getClass() == type) {
            return (T)this.rightValue;
        }
        return null;
    }

    public void ifIsLeft(@NotNull @NotNull Consumer<@NotNull Left> consumer) {
        if (this.isLeft()) {
            consumer.accept(Objects.requireNonNull(this.leftValue));
        }
    }

    public void ifIsRight(@NotNull @NotNull Consumer<@NotNull Right> consumer) {
        if (this.isRight()) {
            consumer.accept(Objects.requireNonNull(this.rightValue));
        }
    }

    @NotNull
    public static <Left, Right> AnyOfPair<Left, Right> ofLeft(Left value) {
        return new AnyOfPair<Left, Object>(value, null);
    }

    @NotNull
    public static <Left, Right> AnyOfPair<Left, Right> ofRight(Right value) {
        return new AnyOfPair<Object, Right>(null, value);
    }

    @NotNull
    public static <Left, Right> AnyOfPair<Left, Right> of(Left leftValue, @NotNull Class<? extends Right> rightType) {
        return AnyOfPair.ofLeft(leftValue);
    }

    @NotNull
    public static <Left, Right> AnyOfPair<Left, Right> of(@NotNull Class<? extends Left> leftType, Right rightValue) {
        return AnyOfPair.ofRight(rightValue);
    }

    @NotNull
    public String toString() {
        return this.isLeft() ? Objects.requireNonNull(this.leftValue).toString() : Objects.requireNonNull(this.rightValue).toString();
    }
}

