/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.updatechecker;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.aratakileo.elegantia.exception.NoSuchModException;
import io.github.aratakileo.elegantia.updatechecker.Response;
import io.github.aratakileo.elegantia.updatechecker.ResponseCode;
import io.github.aratakileo.elegantia.updatechecker.SuccessfulResponse;
import io.github.aratakileo.elegantia.util.ModInfo;
import io.github.aratakileo.elegantia.util.Platform;
import io.github.aratakileo.elegantia.util.Versions;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModrinthUpdateChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModrinthUpdateChecker.class);
    private static final String NOT_FORMATTED_REQUEST_URL = "https://api.modrinth.com/v2/project/{project_id}/version?game_versions=%5B%22{minecraft_version}%22%5D&loaders=%5B%22{platform}%22%5D";
    private static final String NOT_FORMATTED_VERSION_PAGE_URL = "https://modrinth.com/mod/{project_id}/version/{version_id}";
    private static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();
    private final String modId;
    private final String projectId;
    private final String minecraftVersion;
    @Nullable
    private Response lastResponse = null;

    public ModrinthUpdateChecker(@NotNull String modAndProjectId) {
        this(modAndProjectId, modAndProjectId);
    }

    public ModrinthUpdateChecker(@NotNull String modId, @NotNull String projectId) {
        this(modId, projectId, Platform.getMinecraftVersion());
    }

    public ModrinthUpdateChecker(@NotNull String modId, @NotNull String projectId, @NotNull String minecraftVersion) {
        this.modId = modId;
        this.projectId = projectId;
        this.minecraftVersion = minecraftVersion;
    }

    @NotNull
    public Response check() {
        return this.check(null);
    }

    @NotNull
    public Response check(@Nullable Platform platform) {
        try {
            ModInfo.throwIfModIsNotLoaded(this.modId);
            platform = Objects.requireNonNullElse(platform, ModInfo.getKernelPlatform(this.modId).orElseThrow());
            String requestHeader = this.getRequestHeader();
            HttpRequest request = HttpRequest.newBuilder(URI.create(this.getRequestUrl(platform))).setHeader("User-Agent", requestHeader).build();
            LOGGER.info("Checking updates for mod with id `{}` (modrinth project id: {}) with request header `{}` for {}", new Object[]{this.modId, this.projectId, requestHeader, "%s platform (minecraft v%s)".formatted(new Object[]{platform, this.minecraftVersion})});
            HttpResponse<String> basicResponse = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            switch (basicResponse.statusCode()) {
                case 404: {
                    this.lastResponse = Response.of(ResponseCode.DOES_NOT_EXIST_AT_MODRINTH);
                    return this.lastResponse;
                }
                case 200: {
                    break;
                }
                default: {
                    throw new InvalidResponseCodeException(basicResponse.statusCode());
                }
            }
            JsonArray versionsMetadata = JsonParser.parseString((String)basicResponse.body()).getAsJsonArray();
            if (versionsMetadata.isEmpty()) {
                this.lastResponse = Response.of(ResponseCode.NO_VERSIONS_FOUND);
                return this.lastResponse;
            }
            JsonObject versionInfo = versionsMetadata.get(0).getAsJsonObject();
            String modrinthProjectVersion = versionInfo.get("version_number").getAsString();
            String versionId = versionInfo.get("id").getAsString();
            String modVersion = ModInfo.getVersion(this.modId).orElseThrow();
            boolean isNewVersionAvailable = Versions.isGreaterThan(Versions.getVersionKernel(modVersion).orElseThrow(() -> new InvalidVersionFormatException("`%s` of mod with id `%s`".formatted(modVersion, this.modId))), Versions.getVersionKernel(modrinthProjectVersion).orElseThrow(() -> new InvalidVersionFormatException("`%s` of modrinth project with id `%s`".formatted(modrinthProjectVersion, this.projectId))));
            this.lastResponse = Response.of(isNewVersionAvailable ? ResponseCode.NEW_VERSION_IS_AVAILABLE : ResponseCode.SUCCESSFUL, modrinthProjectVersion, NOT_FORMATTED_VERSION_PAGE_URL.replace("{project_id}", this.projectId).replace("{version_id}", versionId), versionInfo.get("files").getAsJsonArray().get(0).getAsJsonObject().get("url").getAsString());
        }
        catch (NoSuchModException | InvalidVersionFormatException | IOException | InterruptedException e) {
            LOGGER.error("Failed to check updates for mod with id `%s` (modrinth project id: %s) v%s".formatted(this.modId, this.projectId, ModInfo.getVersion(this.modId).orElse("-unknown")), (Throwable)e);
            this.lastResponse = Response.of(ResponseCode.FAILED);
        }
        return this.lastResponse;
    }

    @NotNull
    public Optional<Response> getLastResponse() {
        return Optional.ofNullable(this.lastResponse);
    }

    @NotNull
    public Optional<SuccessfulResponse> getLastResponseAsSuccessful() {
        Optional<SuccessfulResponse> optional;
        Response response = this.lastResponse;
        if (response instanceof SuccessfulResponse) {
            SuccessfulResponse successfulResponse = (SuccessfulResponse)response;
            optional = Optional.of(successfulResponse);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    @NotNull
    private String getRequestUrl(@NotNull Platform platform) {
        return NOT_FORMATTED_REQUEST_URL.replace("{project_id}", this.projectId).replace("{minecraft_version}", this.minecraftVersion).replace("{platform}", platform.name().toLowerCase());
    }

    @NotNull
    private String getRequestHeader() {
        String baseRequestHeader = ModrinthUpdateChecker.getVersionedSourceUrl(ModInfo.get("elegantia").orElseThrow()).orElseThrow();
        if (this.modId.equals("elegantia")) {
            return baseRequestHeader;
        }
        ModInfo modInfo = ModInfo.get(this.modId).orElseThrow();
        return "%s for 3rd party mod %s".formatted(baseRequestHeader, ModrinthUpdateChecker.getVersionedSourceUrl(modInfo).orElse("`%s` (mod id: %s)".formatted(modInfo.getName(), this.modId)));
    }

    @NotNull
    public static Response quickCheck(@NotNull String modAndProjectId) {
        return new ModrinthUpdateChecker(modAndProjectId).check();
    }

    @NotNull
    public static Response quickCheck(@NotNull String modId, @NotNull String projectId) {
        return new ModrinthUpdateChecker(modId, projectId).check();
    }

    @NotNull
    private static Optional<String> getVersionedSourceUrl(@NotNull ModInfo modInfo) {
        return modInfo.getSourcesUrl().map(sourceUrl -> "%s@%s".formatted(sourceUrl.strip().replaceFirst("^https?://", ""), modInfo.getVersion()));
    }

    public static class InvalidResponseCodeException
    extends RuntimeException {
        public InvalidResponseCodeException(int code) {
            super(String.valueOf(code));
        }

        public InvalidResponseCodeException(@NotNull String message) {
            super(message);
        }
    }

    public static class InvalidVersionFormatException
    extends RuntimeException {
        public InvalidVersionFormatException(@NotNull String message) {
            super(message);
        }
    }
}

