/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.math;

import io.github.aratakileo.elegantia.math.Vector2iInterface;
import io.github.aratakileo.elegantia.math.Vector2ic;
import org.jetbrains.annotations.NotNull;

public class Vector2i
implements Vector2iInterface {
    public int x;
    public int y;

    public Vector2i(int @NotNull [] vector) {
        this.x = vector[0];
        this.y = vector[1];
    }

    public Vector2i(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    @NotNull
    public Vector2i set(int index, int value) {
        switch (index) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    @Override
    @NotNull
    public Vector2i neg() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    @Override
    @NotNull
    public Vector2i abs() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        return this;
    }

    @Override
    @NotNull
    public Vector2i sub(int value) {
        return this.sub(value, value);
    }

    @Override
    @NotNull
    public Vector2i sub(int x, int y) {
        this.x -= x;
        this.y -= y;
        return this;
    }

    @Override
    @NotNull
    public Vector2i sub(@NotNull Vector2iInterface vector2iInterface) {
        return this.sub(vector2iInterface.x(), vector2iInterface.y());
    }

    @Override
    @NotNull
    public Vector2i sub(@NotNull org.joml.Vector2ic vector2ic) {
        return this.sub(vector2ic.x(), vector2ic.y());
    }

    @Override
    @NotNull
    public Vector2i add(int value) {
        return this.add(value, value);
    }

    @Override
    @NotNull
    public Vector2i add(int x, int y) {
        this.x += x;
        this.y += y;
        return this;
    }

    @Override
    @NotNull
    public Vector2i add(@NotNull Vector2iInterface vector2iInterface) {
        return this.add(vector2iInterface.x(), vector2iInterface.y());
    }

    @Override
    @NotNull
    public Vector2i add(@NotNull org.joml.Vector2ic vector2ic) {
        return this.add(vector2ic.x(), vector2ic.y());
    }

    @Override
    @NotNull
    public Vector2i mul(int value) {
        return this.mul(value, value);
    }

    @Override
    @NotNull
    public Vector2i mul(int x, int y) {
        this.x *= x;
        this.y *= y;
        return this;
    }

    @Override
    @NotNull
    public Vector2i mul(@NotNull Vector2iInterface vector2iInterface) {
        return this.mul(vector2iInterface.x(), vector2iInterface.y());
    }

    @Override
    @NotNull
    public Vector2i mul(@NotNull org.joml.Vector2ic vector2ic) {
        return this.mul(vector2ic.x(), vector2ic.y());
    }

    @Override
    @NotNull
    public Vector2i div(int value) {
        return this.div(value, value);
    }

    @Override
    @NotNull
    public Vector2i div(int x, int y) {
        this.x /= x;
        this.y /= y;
        return this;
    }

    @Override
    @NotNull
    public Vector2i div(@NotNull Vector2iInterface vector2iInterface) {
        return this.div(vector2iInterface.x(), vector2iInterface.y());
    }

    @Override
    @NotNull
    public Vector2i div(@NotNull org.joml.Vector2ic vector2ic) {
        return this.div(vector2ic.x(), vector2ic.y());
    }

    @Override
    @NotNull
    public Vector2i copy() {
        return new Vector2i(this.x, this.y);
    }

    @NotNull
    public Vector2ic copyAsImmutable() {
        return new Vector2ic(this.x, this.y);
    }

    public String toString() {
        return "Vector2i{%d, %d}".formatted(this.x, this.y);
    }

    @NotNull
    public static Vector2i of(@NotNull org.joml.Vector2ic vector2ic) {
        return new Vector2i(vector2ic.x(), vector2ic.y());
    }
}

