/*
 * Decompiled with CFR 0.152.
 */
package io.github.aratakileo.elegantia.math;

import io.github.aratakileo.elegantia.math.Vector2iInterface;
import io.github.aratakileo.elegantia.math.VectorInterface;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;

public interface Vector2dInterface
extends VectorInterface<Vector2dInterface> {
    public double x();

    public double y();

    default public double get(int index) {
        return switch (index) {
            case 0 -> this.x();
            case 1 -> this.y();
            default -> throw new IllegalArgumentException();
        };
    }

    default public double length() {
        return Math.sqrt(this.x() * this.x() + this.y() * this.y());
    }

    @Override
    @NotNull
    public Vector2dInterface sub(double var1);

    @NotNull
    public Vector2dInterface sub(double var1, double var3);

    @Override
    @NotNull
    public Vector2dInterface sub(@NotNull Vector2iInterface var1);

    @Override
    @NotNull
    public Vector2dInterface sub(@NotNull Vector2ic var1);

    @Override
    @NotNull
    public Vector2dInterface sub(@NotNull Vector2dc var1);

    @Override
    @NotNull
    public Vector2dInterface sub(@NotNull Vector2fc var1);

    @Override
    @NotNull
    public Vector2dInterface add(double var1);

    @NotNull
    public Vector2dInterface add(double var1, double var3);

    @Override
    @NotNull
    public Vector2dInterface add(@NotNull Vector2iInterface var1);

    @Override
    @NotNull
    public Vector2dInterface add(@NotNull Vector2ic var1);

    @Override
    @NotNull
    public Vector2dInterface add(@NotNull Vector2dc var1);

    @Override
    @NotNull
    public Vector2dInterface add(@NotNull Vector2fc var1);

    @Override
    @NotNull
    public Vector2dInterface mul(double var1);

    @NotNull
    public Vector2dInterface mul(double var1, double var3);

    @Override
    @NotNull
    public Vector2dInterface mul(@NotNull Vector2iInterface var1);

    @Override
    @NotNull
    public Vector2dInterface mul(@NotNull Vector2ic var1);

    @Override
    @NotNull
    public Vector2dInterface mul(@NotNull Vector2dc var1);

    @Override
    @NotNull
    public Vector2dInterface mul(@NotNull Vector2fc var1);

    @Override
    @NotNull
    public Vector2dInterface div(double var1);

    @NotNull
    public Vector2dInterface div(double var1, double var3);

    @Override
    @NotNull
    public Vector2dInterface div(@NotNull Vector2iInterface var1);

    @Override
    @NotNull
    public Vector2dInterface div(@NotNull Vector2ic var1);

    @Override
    @NotNull
    public Vector2dInterface div(@NotNull Vector2dc var1);

    @Override
    @NotNull
    public Vector2dInterface div(@NotNull Vector2fc var1);

    @NotNull
    public Vector2dInterface floor();

    @NotNull
    public Vector2dInterface ceil();

    @NotNull
    public Vector2dInterface round();

    default public boolean equals(int x, int y) {
        return this.equals((double)x, (double)y);
    }

    default public boolean equals(double x, double y) {
        return Double.doubleToLongBits(x) == Double.doubleToLongBits(this.x()) && Double.doubleToLongBits(y) == Double.doubleToLongBits(this.y());
    }

    default public boolean equals(float x, float y) {
        return this.equals((double)x, (double)y);
    }
}

